/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.osee.framework.jdk.core.collection.tree.TreeNode;
import org.eclipse.osee.framework.jdk.core.util.xml.parser.XmlNode;

public class XmlTreeUtilities {
    private static XmlTreeUtilities instance = null;

    private XmlTreeUtilities() {
    }

    public static XmlTreeUtilities getInstance() {
        if (instance == null) {
            instance = new XmlTreeUtilities();
        }
        return instance;
    }

    private Stack<String> processPath(String pattern) {
        Stack<String> elementPath = new Stack<String>();
        String[] path = pattern.split("/");
        int index = path.length - 1;
        while (index >= 0) {
            String entry = path[index];
            if ((entry = entry.trim()).length() > 0) {
                elementPath.push(entry);
            }
            --index;
        }
        return elementPath;
    }

    public List<TreeNode<XmlNode>> getXmlNodesAt(String path, TreeNode<XmlNode> root) {
        Stack<String> elementPath = this.processPath(path);
        ArrayList<TreeNode<XmlNode>> toReturn = new ArrayList<TreeNode<XmlNode>>();
        List<TreeNode<XmlNode>> nodes = root.getChildren();
        while (!elementPath.empty()) {
            String token = elementPath.pop();
            nodes = this.collectNodesMatchingToken(token, nodes);
        }
        if (nodes != null && nodes.size() > 0) {
            toReturn.addAll(nodes);
        }
        return toReturn;
    }

    private List<TreeNode<XmlNode>> collectNodesMatchingToken(String token, List<TreeNode<XmlNode>> nodes) {
        ArrayList<TreeNode<XmlNode>> toReturn = new ArrayList<TreeNode<XmlNode>>();
        for (TreeNode<XmlNode> node : nodes) {
            if (token.equalsIgnoreCase("*") && node.getChildren().size() > 0) {
                toReturn.addAll(node.getChildren());
            }
            if (!node.getSelf().getName().equalsIgnoreCase(token)) continue;
            toReturn.add(node);
            if (node.getChildren().size() <= 0) continue;
            toReturn.addAll(node.getChildren());
        }
        return toReturn;
    }

    public int countNodesMatchingText(List<TreeNode<XmlNode>> nodes, String toMatch) {
        int result = 0;
        for (TreeNode<XmlNode> node : nodes) {
            String content;
            if (node == null || !(content = node.getSelf().getTextContent()).equalsIgnoreCase(toMatch)) continue;
            ++result;
        }
        return result;
    }

    public XmlNode getFirstXmlNode(List<TreeNode<XmlNode>> nodes) {
        XmlNode toReturn = null;
        if (nodes.size() > 0) {
            toReturn = nodes.get(0).getSelf();
        }
        return toReturn;
    }

    public String getFirstXmlNodeText(List<TreeNode<XmlNode>> nodes) {
        XmlNode node = this.getFirstXmlNode(nodes);
        return node != null ? node.getTextContent() : "";
    }

    public boolean containsNode(String path, TreeNode<XmlNode> nodes) {
        List<TreeNode<XmlNode>> searchResults = this.getXmlNodesAt("Location", nodes);
        return searchResults.size() > 0;
    }

    public String getTextAtPath(String path, TreeNode<XmlNode> nodes) {
        return this.getFirstXmlNodeText(this.getXmlNodesAt(path, nodes));
    }

    public XmlNode getXmlNodeAtPath(String path, TreeNode<XmlNode> nodes) {
        return this.getFirstXmlNode(this.getXmlNodesAt(path, nodes));
    }
}

