/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.collection.tree.Tree;
import org.eclipse.osee.framework.jdk.core.collection.tree.TreeNode;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.xml.parser.IProcessingInstructionsListener;
import org.eclipse.osee.framework.jdk.core.util.xml.parser.IXmlNodeListener;
import org.eclipse.osee.framework.jdk.core.util.xml.parser.XmlNode;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class GenericParser
extends AbstractSaxHandler {
    private final String toFind;
    private boolean startCollecting;
    private Tree<XmlNode> collectedTree;
    private TreeNode<XmlNode> currentNode;
    private final Set<IXmlNodeListener> listeners;
    private final Set<IProcessingInstructionsListener> instructionListeners;
    private static XMLReader xmlReader;

    public GenericParser(String startTag) {
        this.toFind = startTag;
        this.listeners = new HashSet<IXmlNodeListener>();
        this.instructionListeners = new HashSet<IProcessingInstructionsListener>();
    }

    public void reset() {
        this.startCollecting = false;
        this.currentNode = null;
        this.collectedTree = null;
    }

    @Override
    public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equalsIgnoreCase(this.toFind)) {
            this.startCollecting = true;
            this.collectedTree = new Tree<XmlNode>(new XmlNode(localName, attributes));
            this.currentNode = null;
        }
        if (this.startCollecting) {
            XmlNode node = new XmlNode(localName, attributes);
            this.currentNode = this.currentNode == null ? this.collectedTree.getRoot() : this.currentNode.addChild(node);
        }
    }

    @Override
    public void endElementFound(String uri, String localName, String qName) {
        if (localName.equalsIgnoreCase(this.toFind)) {
            this.startCollecting = false;
            this.notifyTreeCollected(this.collectedTree);
        }
        if (this.startCollecting && this.currentNode != null) {
            this.currentNode.getSelf().setTextContent(this.getContents());
            if (this.currentNode.getSelf().getName().equalsIgnoreCase(localName)) {
                TreeNode<XmlNode> parent = this.currentNode.getParent();
                this.currentNode = parent;
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        this.notifyProcessingInstructionChanged(target, data);
    }

    public synchronized void registerInstructionListener(IProcessingInstructionsListener listener) {
        if (!this.instructionListeners.contains(listener)) {
            this.instructionListeners.add(listener);
        }
    }

    public synchronized void deregisterInstructionListener(IProcessingInstructionsListener listener) {
        if (this.instructionListeners.contains(listener)) {
            this.instructionListeners.remove(listener);
        }
    }

    public synchronized void registerXmlNodeListener(IXmlNodeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void deregisterXmlNodeListener(IXmlNodeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void notifyTreeCollected(Tree<XmlNode> tree) {
        TreeNode<XmlNode> root = tree.getRoot();
        for (IXmlNodeListener listener : this.listeners) {
            listener.collectionChanged(root);
        }
    }

    public synchronized void notifyProcessingInstructionChanged(String target, String data) {
        for (IProcessingInstructionsListener listener : this.instructionListeners) {
            listener.processingInstructionChanged(target, data);
        }
    }

    public void process(File xmlSource) throws SAXException, IOException {
        this.reset();
        this.process(new FileInputStream(xmlSource));
    }

    public void process(InputStream xmlSource) throws SAXException, IOException {
        this.reset();
        if (xmlReader == null) {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                exception.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException exception) {
                exception.printStackTrace();
            }

            @Override
            public void error(SAXParseException exception) {
                exception.printStackTrace();
            }
        });
        xmlReader.parse(new InputSource(xmlSource));
        System.out.println();
    }
}

