/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.nio.CharBuffer;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlTranslation {
    public static CharBuffer applyXsl(CharBuffer xmlBuffer, CharBuffer xslBuffer, URIResolver uriResolver) {
        return XmlTranslation.applyXsl(new StreamSource(new CharArrayReader(xmlBuffer.array())), xslBuffer, uriResolver);
    }

    public static CharBuffer applyXsl(Source source, CharBuffer xslBuffer, URIResolver uriResolver) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(uriResolver);
            Templates template = factory.newTemplates(new StreamSource(new CharArrayReader(xslBuffer.array())));
            Transformer xformer = template.newTransformer();
            CharArrayWriter resultWriter = new CharArrayWriter(10000);
            StreamResult result = new StreamResult(resultWriter);
            xformer.transform(source, result);
            return CharBuffer.wrap(resultWriter.toCharArray());
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

