/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;

public abstract class AbstractSheetWriter
implements ISheetWriter {
    private boolean startRow = true;
    private int implicitCellIndex = 0;

    protected void startRowIfNecessary() throws IOException {
        if (this.startRow) {
            this.startRow();
            this.startRow = false;
        }
    }

    @Override
    public void writeRow(Collection<?> row) throws IOException {
        this.writeRow(row.toArray(new Object[row.size()]));
    }

    @Override
    public void writeRow(Object ... row) throws IOException {
        int i = 0;
        while (i < row.length) {
            this.writeCell(row[i], this.implicitCellIndex);
            ++i;
        }
        this.endRow();
    }

    @Override
    public void writeCell(Object data, int cellIndex) throws IOException {
        this.startRowIfNecessary();
        this.implicitCellIndex = cellIndex + 1;
        this.writeCellText(data, cellIndex);
    }

    @Override
    public void endRow() throws IOException {
        this.startRowIfNecessary();
        this.startRow = true;
        this.implicitCellIndex = 0;
        this.writeEndRow();
    }

    @Override
    public void writeCell(Object cellData) throws IOException {
        this.writeCell(cellData, this.implicitCellIndex);
    }

    @Override
    public void writeEmptyCell() throws IOException {
        this.writeCell(null);
    }

    protected abstract void startRow() throws IOException;

    protected abstract void writeEndRow() throws IOException;

    protected abstract void writeCellText(Object var1, int var2) throws IOException;
}

