/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.IZipEntryCompleteCallback;

public class Zip {
    public static void zip(String[] filenames, String outFilename) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            int i = 0;
            while (i < filenames.length) {
                int len;
                FileInputStream in = new FileInputStream(filenames[i]);
                out.putNextEntry(new ZipEntry(filenames[i]));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static void unzip(File zipFile, File destinationDir, IZipEntryCompleteCallback progressBar) throws IOException {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipEntry entry = null;
        try {
            ZipFile zipfile = new ZipFile(zipFile.getAbsolutePath());
            progressBar.setValue(0);
            progressBar.setMinimum(0);
            progressBar.setMaximum(zipfile.size());
            System.out.println(zipfile.size());
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            int size = 0;
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                File fileDir = new File(String.valueOf(destinationDir.getAbsolutePath()) + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    fileDir.mkdirs();
                    progressBar.setValue(++size);
                    continue;
                }
                fileDir.getParentFile().mkdirs();
                if (!fileDir.exists() || fileDir.exists() && fileDir.canWrite()) {
                    int count;
                    FileOutputStream fos = new FileOutputStream(fileDir.getAbsolutePath());
                    dest = new BufferedOutputStream(fos, BUFFER);
                    while ((count = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                }
                is.close();
                if (fileDir.getAbsolutePath().endsWith(".lnk") && fileDir.canWrite()) {
                    fileDir.setReadOnly();
                }
                progressBar.setValue(++size);
            }
        }
        catch (RuntimeException ex) {
            String information = "ZipFile: " + (zipFile != null ? zipFile.getAbsolutePath() : "NULL") + "\n" + "DestinationDir: " + (destinationDir != null ? destinationDir.getAbsolutePath() : "NULL") + "\n" + "Entry Processed: " + (entry != null ? entry.toString() : "NULL") + "\n";
            Lib.close(is);
            throw new IOException(String.valueOf(information) + ex.getMessage());
        }
    }
}

