/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;

public class CharBackedInputStream
extends InputStream
implements Appendable {
    private final LinkedList<ByteBuffer> backers;
    private ByteBuffer currentBacker;
    private final CharsetEncoder encoder;
    private Writer writer;

    public CharBackedInputStream(CharBuffer source, String encodingName) throws CharacterCodingException {
        this.encoder = Charset.forName(encodingName).newEncoder();
        this.backers = new LinkedList();
        if (source != null) {
            this.addBackingSource(source);
        }
    }

    public CharBackedInputStream() throws CharacterCodingException {
        this((CharBuffer)null, "UTF-8");
    }

    public CharBackedInputStream(CharSequence backingStr) throws CharacterCodingException {
        this(backingStr, "UTF-8");
    }

    public CharBackedInputStream(char[] backingChars) throws CharacterCodingException {
        this(backingChars, "UTF-8");
    }

    public CharBackedInputStream(char[] backingChars, String encodingName) throws CharacterCodingException {
        this(CharBuffer.wrap(backingChars), encodingName);
    }

    public CharBackedInputStream(CharSequence backingStr, String encodingName) throws CharacterCodingException {
        this(CharBuffer.wrap(backingStr), encodingName);
    }

    public void addBackingSource(CharSequence backingStr) throws CharacterCodingException {
        this.addBackingSource(CharBuffer.wrap(backingStr));
    }

    public void addBackingSource(CharSequence backingStr, int off, int len) throws CharacterCodingException {
        this.addBackingSource(CharBuffer.wrap(backingStr.subSequence(off, len + off)));
    }

    public void addBackingSource(char[] chars, int off, int len) throws CharacterCodingException {
        this.addBackingSource(CharBuffer.wrap(chars, off, len));
    }

    public void addBackingSource(char[] chars) throws CharacterCodingException {
        this.addBackingSource(CharBuffer.wrap(chars));
    }

    public void addBackingSource(CharBuffer source) throws CharacterCodingException {
        ByteBuffer buffer = this.encoder.encode(source);
        if (this.currentBacker == null) {
            this.currentBacker = buffer;
        } else {
            this.backers.add(buffer);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentBacker == null) {
            return -1;
        }
        try {
            return this.currentBacker.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.currentBacker = this.backers.poll();
            return this.read();
        }
    }

    public Writer getWriter() {
        if (this.writer == null) {
            this.writer = new InputStreamWriter();
        }
        return this.writer;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.addBackingSource(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.addBackingSource(csq, start, end - start);
        return this;
    }

    @Override
    public Appendable append(char c) {
        throw new UnsupportedOperationException("doing this one character at a time would be so inefficient it would defeat the whole purpose of this class");
    }

    @Override
    public int available() {
        int count = 0;
        for (ByteBuffer backer : this.backers) {
            count += backer.array().length;
        }
        return count;
    }

    public class InputStreamWriter
    extends Writer {
        public InputStreamWriter() {
        }

        public InputStreamWriter(Object lock) {
            super(lock);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            CharBackedInputStream.this.addBackingSource(cbuf, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public void write(CharSequence str) throws CharacterCodingException {
            CharBackedInputStream.this.addBackingSource(str);
        }

        @Override
        public void write(String str, int off, int len) throws CharacterCodingException {
            CharBackedInputStream.this.addBackingSource(str, off, len);
        }
    }
}

