/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarCreator {
    private final JarOutputStream out;
    private final byte[] buffer;

    public JarCreator(File path, String title, String version) throws FileNotFoundException, IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Implementation-Title", title);
        attributes.putValue("Implementation-Version", version);
        this.out = new JarOutputStream((OutputStream)new FileOutputStream(path), manifest);
        this.buffer = new byte[20480];
    }

    private void addFile(File file, String pathInJar) throws IOException {
        int bytesRead;
        this.out.putNextEntry(new JarEntry(pathInJar.replace('\\', '/')));
        FileInputStream in = new FileInputStream(file);
        while ((bytesRead = in.read(this.buffer)) != -1) {
            this.out.write(this.buffer, 0, bytesRead);
        }
        in.close();
    }

    private void addRelativeToPosition(File path, int rootPathPos, FileFilter filenameFilter) throws IOException {
        if (path.isDirectory()) {
            File[] files = path.listFiles(filenameFilter);
            int i = 0;
            while (i < files.length) {
                this.addRelativeToPosition(files[i], rootPathPos, filenameFilter);
                ++i;
            }
        } else {
            this.addFile(path, path.getAbsolutePath().substring(rootPathPos));
        }
    }

    private void addDirectoryContents(File directory, FileFilter filenameFilter) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Must be a directory: " + directory);
        }
        int rootPathPos = directory.getPath().length() + 1;
        this.addRelativeToPosition(directory, rootPathPos, filenameFilter);
    }

    public void addFileRelativeTo(File path, String relativeTo) throws IOException {
        this.addRelativeToPosition(path, relativeTo.length() + 1, null);
    }

    public void addDirectoryContents(File directory) throws IOException {
        this.addDirectoryContents(directory, (FileFilter)null);
    }

    public void addDirectoryContents(File directory, String fileNamePattern) throws IOException {
        this.addDirectoryContents(directory, new FilenameAndDirectoryFilter(fileNamePattern));
    }

    public void close() throws IOException {
        this.out.close();
    }

    private static class FilenameAndDirectoryFilter
    implements FileFilter {
        private final Matcher matcher;

        public FilenameAndDirectoryFilter(String pattern) {
            this.matcher = Pattern.compile(pattern).matcher("");
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            this.matcher.reset(pathname.getName());
            return this.matcher.matches();
        }
    }
}

