/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public final class Conditions {
    private Conditions() {
    }

    public static boolean in(Object equalTo, Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (equalTo.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean notNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean anyNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasValues(Collection<?> toCheck) {
        return toCheck != null && !toCheck.isEmpty();
    }

    public static boolean hasValues(Object[] toCheck) {
        return toCheck != null && toCheck.length > 0;
    }

    public static boolean allNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void checkNotNull(Object object, String objectName) throws OseeCoreException {
        if (object == null) {
            throw new OseeArgumentException("%s cannot be null", objectName);
        }
    }

    public static void checkNotNull(Object object, String objectName, String details, Object ... data) throws OseeCoreException {
        if (object == null) {
            String message = String.format(details, data);
            throw new OseeArgumentException("%s cannot be null - %s", objectName, message);
        }
    }

    public static void checkNotNullOrEmpty(String object, String objectName) throws OseeCoreException {
        Conditions.checkNotNull(object, objectName);
        if (object.length() == 0) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(Object[] array, String objectName) throws OseeCoreException {
        Conditions.checkNotNull(array, objectName);
        if (array.length <= 0) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(Collection<? extends Object> collection, String objectName) throws OseeCoreException {
        Conditions.checkNotNull(collection, objectName);
        if (collection.isEmpty()) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(String object, String objectName, String details, Object ... data) throws OseeCoreException {
        Conditions.checkNotNull(object, objectName, details, data);
        if (object.length() == 0) {
            String message = String.format(details, data);
            throw new OseeArgumentException("%s cannot be empty - %s", objectName, message);
        }
    }

    public static void checkExpressionFailOnTrue(boolean result, String message, Object ... data) throws OseeCoreException {
        if (result) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void checkDoesNotContainNulls(Object object, String message, Object ... data) throws OseeCoreException {
        Conditions.checkNotNull(object, message);
        List<Object> toCheck = null;
        if (object instanceof Collection) {
            toCheck = (List<Object>)object;
        } else if (object instanceof Object[]) {
            toCheck = Arrays.asList((Object[])object);
        }
        if (toCheck != null) {
            for (Object e : toCheck) {
                if (e != null) continue;
                throw new OseeArgumentException(message, data);
            }
        } else {
            throw new OseeArgumentException("object is not an array or a collection", new Object[0]);
        }
    }

    public static void checkNotNullOrEmptyOrContainNull(Collection<? extends Object> collection, String objectName) throws OseeCoreException {
        Conditions.checkNotNullOrEmpty(collection, objectName);
        for (Object object : collection) {
            Conditions.checkNotNull(object, objectName);
        }
    }

    public static void checkNotNullOrContainNull(Collection<? extends Object> collection, String objectName) throws OseeCoreException {
        Conditions.checkNotNull(collection, objectName);
        for (Object object : collection) {
            Conditions.checkNotNull(object, objectName);
        }
    }

    public static void assertEquals(int value1, int value2, String message) {
        Conditions.checkExpressionFailOnTrue(value1 != value2, String.valueOf(message) + " - Expected %d; Actual %d", value1, value2);
    }

    public static void assertEquals(int value1, int value2) {
        Conditions.assertEquals(value1, value2, "");
    }

    public static void assertEquals(String expected, String actual) {
        Conditions.assertTrue(expected.equals(actual), "Expected %1; Actual %2", expected, actual);
    }

    public static void assertTrue(boolean value, String message, Object ... data) {
        if (!value) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void assertNotNull(Object obj, String message, Object ... data) {
        if (obj == null) {
            throw new OseeArgumentException(message, data);
        }
    }
}

