/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetIterable;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;
import org.eclipse.osee.framework.jdk.core.type.ResultSetTransform;

public final class ResultSets {
    private static final ResultSet EMPTY_RESULT_SET = new ResultSetList(Collections.emptyList());

    private ResultSets() {
    }

    public static <T> ResultSet<T> newResultSet(T ... item) {
        ResultSet<T> toReturn = item == null || item.length <= 0 ? ResultSets.emptyResultSet() : ResultSets.newResultSet(Arrays.asList(item));
        return toReturn;
    }

    public static <T> ResultSet<T> singleton(T item) {
        ResultSet<T> toReturn = item == null ? ResultSets.emptyResultSet() : new ResultSetList<T>(Collections.singletonList(item));
        return toReturn;
    }

    public static <T> ResultSet<T> newResultSet(List<T> list) {
        ResultSet<T> toReturn = list == null || list.isEmpty() ? ResultSets.emptyResultSet() : new ResultSetList<T>(list);
        return toReturn;
    }

    public static <T> ResultSet<T> newResultSet(Iterable<T> iterable) {
        ResultSet<T> toReturn = iterable == null || !iterable.iterator().hasNext() ? ResultSets.emptyResultSet() : new ResultSetIterable<T>(iterable);
        return toReturn;
    }

    public static <T> ResultSet<T> emptyResultSet() {
        return EMPTY_RESULT_SET;
    }

    public static <K, F extends Identity<K>, T extends Identity<K>> ResultSet<T> transform(ResultSet<F> result, ResultSetTransform.Function<K, F, T> factory) {
        ResultSet<T> toReturn = result == null || result.isEmpty() ? ResultSets.emptyResultSet() : new ResultSetTransform<K, F, T>(result, factory);
        return toReturn;
    }
}

