/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public class ResultSetTransform<I, F extends Identity<I>, T extends Identity<I>>
implements ResultSet<T> {
    private final ResultSet<F> result;
    private final Function<I, F, T> function;
    private final Map<I, T> objectMap = new HashMap<I, T>();
    private List<T> data;

    protected ResultSetTransform(ResultSet<F> result, Function<I, F, T> factory) {
        this.function = factory;
        this.result = result;
    }

    @Override
    public T getOneOrNull() throws OseeCoreException {
        return this.toObject((Identity)this.result.getOneOrNull());
    }

    @Override
    public T getExactlyOne() throws OseeCoreException {
        return this.toObject((Identity)this.result.getExactlyOne());
    }

    @Override
    public T getAtMostOneOrNull() throws OseeCoreException {
        return this.toObject((Identity)this.result.getAtMostOneOrNull());
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.data != null) {
            return this.data.iterator();
        }
        final Iterator iterator = this.result.iterator();
        return new Iterator<T>(){
            private T current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = ResultSetTransform.this.toObject((Identity)iterator.next());
                return this.current;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                iterator.remove();
                if (this.current != null) {
                    Map map = ResultSetTransform.this.objectMap;
                    synchronized (map) {
                        ResultSetTransform.this.objectMap.remove(this.current.getGuid());
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T toObject(F source) {
        Identity object;
        Object key = source.getGuid();
        Map<I, T> map = this.objectMap;
        synchronized (map) {
            object = (Identity)this.objectMap.get(key);
            if (object == null) {
                object = this.function.apply(source);
                this.objectMap.put(key, object);
            }
        }
        return (T)object;
    }

    @Override
    public ResultSet<T> sort(Comparator<T> comparator) {
        List<T> list = this.getList();
        Collections.sort(list, comparator);
        this.data = list;
        return this;
    }

    @Override
    public List<T> getList() {
        LinkedList<Identity> items = new LinkedList<Identity>();
        for (Identity obj : this.data) {
            items.add(obj);
        }
        return items;
    }

    public static interface Function<I, F extends Identity<I>, T extends Identity<I>> {
        public T apply(F var1);
    }
}

