/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public class ResultSetList<T>
implements ResultSet<T> {
    private final List<T> data;

    protected ResultSetList() {
        this.data = Collections.emptyList();
    }

    public ResultSetList(List<T> data) {
        this.data = data;
    }

    @Override
    public T getOneOrNull() {
        List<T> result = this.getList();
        return result.isEmpty() ? null : (T)result.iterator().next();
    }

    @Override
    public T getAtMostOneOrNull() throws OseeCoreException {
        List<T> result = this.getList();
        if (result.size() > 1) {
            throw this.createManyExistException(result.size());
        }
        return result.isEmpty() ? null : (T)result.iterator().next();
    }

    @Override
    public T getExactlyOne() throws OseeCoreException {
        T result = this.getAtMostOneOrNull();
        if (result == null) {
            throw this.createDoesNotExistException();
        }
        return result;
    }

    @Override
    public List<T> getList() {
        return this.data;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    protected OseeCoreException createManyExistException(int count) {
        return new MultipleItemsExist("Multiple items found - total [%s]", count);
    }

    protected OseeCoreException createDoesNotExistException() {
        return new ItemDoesNotExist("No item found", new Object[0]);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public ResultSet<T> sort(Comparator<T> comparator) {
        Collections.sort(this.getList(), comparator);
        return this;
    }
}

