/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.IInputListener;

public class InputManager<T>
implements IInputListener<T> {
    private final List<T> inputList = Collections.synchronizedList(new ArrayList());
    private final Set<IInputListener<T>> changeListeners = Collections.synchronizedSet(new HashSet());

    public List<T> getInputList() {
        return this.inputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(T inNode) {
        Collection<Object> collection = this.inputList;
        synchronized (collection) {
            this.inputList.add(this.inputList.size(), inNode);
        }
        collection = this.changeListeners;
        synchronized (collection) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().addNode(inNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodes(Collection<T> inNode) {
        Collection<Object> collection = this.inputList;
        synchronized (collection) {
            this.inputList.addAll(inNode);
        }
        collection = this.changeListeners;
        synchronized (collection) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().addNodes(inNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(T inNode) {
        Collection<Object> collection = this.inputList;
        synchronized (collection) {
            this.inputList.remove(inNode);
        }
        collection = this.changeListeners;
        synchronized (collection) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().removeNode(inNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeChanged(T inNode) {
        Set<IInputListener<T>> set = this.changeListeners;
        synchronized (set) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().nodeChanged(inNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputChanged() {
        Set<IInputListener<T>> set = this.changeListeners;
        synchronized (set) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().inputChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Collection<Object> collection = this.inputList;
        synchronized (collection) {
            this.inputList.clear();
        }
        collection = this.changeListeners;
        synchronized (collection) {
            Iterator<IInputListener<T>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().removeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputListener(IInputListener<T> listener) {
        Set<IInputListener<T>> set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.add(listener);
        }
        for (T node : this.inputList) {
            listener.addNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputListener(IInputListener<T> listener) {
        Set<IInputListener<T>> set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<T> list = this.inputList;
        synchronized (list) {
            StringBuilder toReturn = new StringBuilder();
            int i = 0;
            while (i < this.inputList.size()) {
                T node = this.inputList.get(i);
                toReturn.append(node.toString());
                ++i;
            }
            toReturn.append("\n\n");
            return toReturn.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Collection<Object> collection = this.inputList;
        synchronized (collection) {
            this.inputList.clear();
        }
        collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.clear();
        }
    }
}

