/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.eclipse.osee.framework.jdk.core.type.BaseId;

public interface Id {
    public static final Long SENTINEL = -1L;

    public static Id valueOf(String id) {
        return Id.valueOf(Long.valueOf(id));
    }

    @JsonCreator
    public static Id valueOf(long id) {
        return new BaseId(id);
    }

    public Long getId();

    default public String getIdString() {
        return this.getId().toString();
    }

    default public boolean matches(Id ... identities) {
        Id[] idArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            Id identity = idArray[n2];
            if (this.equals(identity)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    default public boolean equals(Long id) {
        return this.getId().equals(id);
    }

    default public boolean notEqual(long id) {
        return !this.equals(id);
    }

    default public boolean notEqual(Id id) {
        return !this.equals(id);
    }

    @JsonIgnore
    default public boolean isValid() {
        return this.getId() > 0L;
    }

    @JsonIgnore
    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public <T extends Id> T minus(T id) {
        return this.clone(this.getId() - id.getId());
    }

    default public <T extends Id> T plus(T id) {
        return this.clone(this.getId() + id.getId());
    }

    default public <T extends Id> T clone(Long id) {
        throw new UnsupportedOperationException();
    }

    default public boolean isLessThan(Id other) {
        return this.getId() < other.getId();
    }

    default public boolean isGreaterThan(Id other) {
        return this.getId() > other.getId();
    }
}

