/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.IPlusProvider;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class HashCollectionPlus<K, V, O> {
    private boolean isSynchronized;
    private Class<? extends Collection> collectionType;
    private IPlusProvider<O> plusProvider;
    private Map<K, Pair<Collection<V>, O>> map;
    public static final Class<? extends Collection> DEFAULT_COLLECTION_TYPE = ArrayList.class;

    public HashCollectionPlus(boolean isSynchronized, Class<? extends Collection> collectionType, int initialCapacity, float loadFactor, IPlusProvider<O> plusProvider) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Pair<Collection<V>, O>>(initialCapacity, loadFactor) : new HashMap<K, Pair<Collection<V>, O>>(initialCapacity, loadFactor);
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
        this.plusProvider = plusProvider;
    }

    public HashCollectionPlus(boolean isSynchronized, Class<? extends Collection> collectionType, int initialCapacity, IPlusProvider<O> plusProvider) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Pair<Collection<V>, O>>(initialCapacity) : new HashMap<K, Pair<Collection<V>, O>>(initialCapacity);
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
        this.plusProvider = plusProvider;
    }

    public HashCollectionPlus(boolean isSynchronized, Class<? extends Collection> collectionType, IPlusProvider<O> plusProvider) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Pair<Collection<V>, O>>() : new HashMap<K, Pair<Collection<V>, O>>();
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
        this.plusProvider = plusProvider;
    }

    public HashCollectionPlus(int initialCapacity, float loadFactor, IPlusProvider<O> plusProvider) {
        this(false, DEFAULT_COLLECTION_TYPE, initialCapacity, loadFactor, plusProvider);
    }

    public HashCollectionPlus(int initialCapacity, IPlusProvider<O> plusProvider) {
        this(false, DEFAULT_COLLECTION_TYPE, initialCapacity, plusProvider);
    }

    public HashCollectionPlus(IPlusProvider<O> plusProvider) {
        this(false, DEFAULT_COLLECTION_TYPE, plusProvider);
    }

    public Collection<V> put(K key, V value) {
        Pair<Collection<Object>, O> objectPair = this.map.get(key);
        if (objectPair == null) {
            try {
                Collection items = this.isSynchronized ? Collections.synchronizedCollection(this.collectionType.newInstance()) : this.collectionType.newInstance();
                objectPair = new Pair(items, this.plusProvider.newObject());
                this.map.put(key, objectPair);
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        objectPair.getFirst().add(value);
        return objectPair.getFirst();
    }

    public Collection<V> put(K key, Collection<V> values) {
        Collection<V> items = null;
        for (V value : values) {
            if (items == null) {
                items = this.put(key, value);
                continue;
            }
            items.add(value);
        }
        return items;
    }

    public boolean removeValue(K key, V value) {
        Collection<V> items;
        Pair<Collection<V>, O> objectPair = this.map.get(key);
        if (objectPair != null && (items = objectPair.getFirst()) != null && items.remove(value)) {
            if (items.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public Collection<V> removeValues(K key) {
        Pair<Collection<V>, O> objectPair = this.map.remove(key);
        Collection<Object> toReturn = objectPair != null ? objectPair.getFirst() : Collections.emptyList();
        return toReturn;
    }

    public Collection<V> getValues(K key) {
        Pair<Collection<V>, O> objectPair = this.map.get(key);
        if (objectPair != null) {
            return objectPair.getFirst();
        }
        return null;
    }

    public List<V> getValues() {
        ArrayList<V> values = new ArrayList<V>();
        for (Pair<Collection<V>, O> objectPair : this.map.values()) {
            if (objectPair == null) continue;
            values.addAll(objectPair.getFirst());
        }
        return values;
    }

    public O getPlusObject(K key) {
        Pair<Collection<V>, O> objectPair = this.map.get(key);
        if (objectPair != null) {
            return this.map.get(key).getSecond();
        }
        return null;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        Set<K> keySet = this.keySet();
        Map<K, Pair<Collection<V>, O>> map = this.map;
        synchronized (map) {
            for (K key : keySet) {
                size += this.getValues(key).size();
            }
        }
        return size;
    }

    public boolean containsValue(Object value) {
        for (Pair<Collection<V>, O> objectPair : this.map.values()) {
            if (objectPair == null) continue;
            for (V tempValue : objectPair.getFirst()) {
                if (!value.equals(tempValue)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }
}

