/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HashCollection<K, V> {
    private boolean isSynchronized;
    private Class<? extends Collection> collectionType;
    private Map<K, Collection<V>> map;
    public static final Class<? extends Collection> DEFAULT_COLLECTION_TYPE = ArrayList.class;

    public HashCollection(boolean isSynchronized, Class<? extends Collection> collectionType, int initialCapacity, float loadFactor) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Collection<V>>(initialCapacity, loadFactor) : new HashMap<K, Collection<V>>(initialCapacity, loadFactor);
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
    }

    public HashCollection(boolean isSynchronized, Class<? extends Collection> collectionType, int initialCapacity) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Collection<V>>(initialCapacity) : new HashMap<K, Collection<V>>(initialCapacity);
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
    }

    public HashCollection(boolean isSynchronized, Class<? extends Collection> collectionType) {
        this.map = isSynchronized ? new ConcurrentHashMap<K, Collection<V>>() : new HashMap<K, Collection<V>>();
        this.isSynchronized = isSynchronized;
        this.collectionType = collectionType;
    }

    public HashCollection(int initialCapacity, float loadFactor) {
        this(false, DEFAULT_COLLECTION_TYPE, initialCapacity, loadFactor);
    }

    public HashCollection(int initialCapacity) {
        this(false, DEFAULT_COLLECTION_TYPE, initialCapacity);
    }

    public HashCollection(boolean isSynchronized) {
        this(isSynchronized, DEFAULT_COLLECTION_TYPE);
    }

    public HashCollection() {
        this(false, DEFAULT_COLLECTION_TYPE, 0);
    }

    public Collection<V> put(K key, V value) {
        Collection collection = this.map.get(key);
        if (collection == null) {
            try {
                collection = this.isSynchronized ? Collections.synchronizedCollection(this.collectionType.newInstance()) : this.collectionType.newInstance();
                this.map.put(key, collection);
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        collection.add(value);
        return collection;
    }

    public Collection<V> put(K key, Collection<V> values) {
        Collection<V> items = null;
        if (values == null || values.isEmpty()) {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new LinkedList());
            }
        } else {
            for (V value : values) {
                if (items == null) {
                    items = this.put(key, value);
                    continue;
                }
                items.add(value);
            }
        }
        return items;
    }

    public boolean removeValue(K key, V value) {
        Collection<V> collection = this.map.get(key);
        if (collection != null && collection.remove(value)) {
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public Collection<V> removeValues(K key) {
        Collection<V> objectPair = this.map.remove(key);
        if (objectPair == null) {
            return Collections.emptyList();
        }
        return objectPair;
    }

    public Collection<V> getValues(K key) {
        return this.map.get(key);
    }

    public List<V> getValues() {
        ArrayList<V> values = new ArrayList<V>();
        for (Collection<V> objectPair : this.map.values()) {
            if (objectPair == null) continue;
            values.addAll(objectPair);
        }
        return values;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        Set<K> keySet = this.keySet();
        Map<K, Collection<V>> map = this.map;
        synchronized (map) {
            for (K key : keySet) {
                size += this.getValues(key).size();
            }
        }
        return size;
    }

    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.map.values()) {
            if (collection == null) continue;
            for (V tempValue : collection) {
                if (!value.equals(tempValue)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }
}

