/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Comparator;
import java.util.PriorityQueue;

public class FixedSizePriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 6408445028193363641L;
    private final int qSize;

    public FixedSizePriorityQueue(int size, Comparator<E> comparator) {
        super(size, comparator);
        this.qSize = size;
    }

    public FixedSizePriorityQueue(int size) {
        super(size);
        this.qSize = size;
    }

    public FixedSizePriorityQueue(int size, E initialElement) {
        this(size);
        this.add(initialElement);
    }

    @Override
    public boolean add(E o) {
        return this.offer(o);
    }

    @Override
    public boolean offer(E o) {
        if (this.size() >= this.qSize) {
            this.poll();
        }
        return super.offer(o);
    }
}

