/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class CompositeKeyHashMap<KeyOne, KeyTwo, Value>
implements Map<Pair<KeyOne, KeyTwo>, Value> {
    private final HashCollection<KeyOne, KeyTwo> singleKeyMap;
    private final Map<Pair<KeyOne, KeyTwo>, Value> map;
    private final ThreadLocal<Pair<KeyOne, KeyTwo>> threadLocalKey = new ThreadLocal<Pair<KeyOne, KeyTwo>>(){

        @Override
        protected Pair<KeyOne, KeyTwo> initialValue() {
            return new Pair<Object, Object>(null, null);
        }
    };

    public CompositeKeyHashMap() {
        this(50, false);
    }

    public CompositeKeyHashMap(int initialCapacity, boolean isThreadSafe) {
        this.map = isThreadSafe ? new ConcurrentHashMap<Pair<KeyOne, KeyTwo>, Value>(initialCapacity) : new HashMap<Pair<KeyOne, KeyTwo>, Value>(initialCapacity);
        this.singleKeyMap = new HashCollection(isThreadSafe, HashSet.class);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.singleKeyMap.clear();
    }

    @Override
    public boolean containsKey(Object key1) {
        return this.singleKeyMap.containsKey(key1);
    }

    public boolean containsKey(KeyOne key1, KeyTwo key2) {
        return this.map.containsKey(this.threadLocalKey.get().set(key1, key2));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.singleKeyMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Pair<KeyOne, KeyTwo>, Value>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Value get(Object key) {
        List<Value> values = this.getValues(key);
        if (values != null && !values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public Map<KeyTwo, Value> getKeyedValues(KeyOne key1) {
        Collection<KeyTwo> key2s = this.singleKeyMap.getValues(key1);
        if (key2s == null) {
            return Collections.emptyMap();
        }
        HashMap<KeyTwo, Value> values = new HashMap<KeyTwo, Value>(key2s.size());
        for (KeyTwo key2 : key2s) {
            values.put(key2, this.get(key1, key2));
        }
        return values;
    }

    public List<Value> getValues(KeyOne key1) {
        Collection<KeyTwo> key2s = this.singleKeyMap.getValues(key1);
        if (key2s == null) {
            return Collections.emptyList();
        }
        ArrayList<Value> values = new ArrayList<Value>(key2s.size());
        for (KeyTwo key2 : key2s) {
            values.add(this.get(key1, key2));
        }
        return values;
    }

    public Value get(KeyOne key1, KeyTwo key2) {
        return this.map.get(this.threadLocalKey.get().set(key1, key2));
    }

    public List<Pair<KeyOne, KeyTwo>> getEnumeratedKeys() {
        ArrayList<Pair<KeyOne, KeyTwo>> toReturn = new ArrayList<Pair<KeyOne, KeyTwo>>();
        for (KeyOne firstKey : this.singleKeyMap.keySet()) {
            for (KeyTwo secondKey : this.singleKeyMap.getValues(firstKey)) {
                toReturn.add(new Pair<KeyOne, KeyTwo>(firstKey, secondKey));
            }
        }
        return toReturn;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Pair<KeyOne, KeyTwo>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Value put(Pair<KeyOne, KeyTwo> key, Value value) {
        this.singleKeyMap.put(key.getFirst(), key.getSecond());
        return this.map.put(key, value);
    }

    public Value put(KeyOne key1, KeyTwo key2, Value value) {
        this.singleKeyMap.put(key1, key2);
        return this.map.put(new Pair<KeyOne, KeyTwo>(key1, key2), value);
    }

    @Override
    public void putAll(Map<? extends Pair<KeyOne, KeyTwo>, ? extends Value> copyMap) {
        this.map.putAll(copyMap);
        for (Pair<KeyOne, KeyTwo> key : copyMap.keySet()) {
            this.singleKeyMap.put(key.getFirst(), key.getSecond());
        }
    }

    @Override
    public Value remove(Object key) {
        Collection<Value> values = this.removeValues(key);
        if (values != null && !values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public Collection<Value> removeValues(KeyOne key1) {
        Collection<KeyTwo> key2s = this.singleKeyMap.getValues(key1);
        if (key2s == null) {
            return null;
        }
        ArrayList<Value> values = new ArrayList<Value>(key2s.size());
        for (KeyTwo key2 : key2s) {
            values.add(this.map.remove(this.threadLocalKey.get().set(key1, key2)));
        }
        this.singleKeyMap.removeValues(key1);
        return values;
    }

    public Value removeAndGet(KeyOne key1, KeyTwo key2) {
        Value value = this.map.remove(this.threadLocalKey.get().set(key1, key2));
        this.singleKeyMap.removeValue(key1, key2);
        return value;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }
}

