/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.osee.framework.jdk.core.text.tool.RpcrSignalChanges;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;

public class SignalChanges {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: java text.SignalChanges <.dat directory> <scirpt source directory>");
            return;
        }
        ArrayList<Object> list = SignalChanges.loadList(args[0]);
        SignalChanges.writeSignalChanges(list, new File(args[0], "cdb_changes.txt"), new File(args[0], "mux_changes.txt"));
        SignalChanges.writeChangeVerification(args[1], list);
    }

    public static ArrayList<Object> loadList(String path) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(20);
        File directory = new File(path);
        Object[] files = directory.listFiles(new MatchFilter(".*\\.txt"));
        Arrays.sort(files);
        System.out.println("Found " + files.length + " dat files in " + path + ".");
        int i = 0;
        while (i < files.length) {
            list.add(new RpcrSignalChanges((File)files[i]));
            ++i;
        }
        return list;
    }

    public static void writeChangeVerification(String scriptsPath, ArrayList<Object> changesList) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter("rpcr_list.txt"));
        File directory = new File(scriptsPath);
        Object[] files = directory.listFiles(new MatchFilter(".*\\.c"));
        Arrays.sort(files);
        System.out.println("Found " + files.length + " script files in " + scriptsPath + ".");
        int i = 0;
        while (i < changesList.size()) {
            RpcrSignalChanges rpCh = (RpcrSignalChanges)changesList.get(i);
            out.write(String.valueOf(rpCh.rpcrName) + "\n");
            int j = 0;
            while (j < files.length) {
                BufferedReader in = new BufferedReader(new FileReader((File)files[j]));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (!rpCh.affectsLine(line)) continue;
                    out.write("\t" + ((File)files[j]).getName() + "\n");
                    break;
                }
                in.close();
                ++j;
            }
            out.flush();
            ++i;
        }
        out.close();
    }

    public static void writeSignalChanges(ArrayList<Object> changesList, File outputFile, File muxOutputFile) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        BufferedWriter muxOut = new BufferedWriter(new FileWriter(muxOutputFile));
        int i = 0;
        while (i < changesList.size()) {
            int j;
            RpcrSignalChanges rpcrCng = (RpcrSignalChanges)changesList.get(i);
            if (rpcrCng.mux) {
                j = 0;
                while (j < rpcrCng.signals.size()) {
                    muxOut.write(String.valueOf(rpcrCng.rpcrName) + "," + rpcrCng.signals.get(j) + "\n");
                    ++j;
                }
            } else {
                j = 0;
                while (j < rpcrCng.signals.size()) {
                    out.write(String.valueOf(rpcrCng.rpcrName) + " " + rpcrCng.signals.get(j) + "\n");
                    ++j;
                }
            }
            ++i;
        }
        out.close();
        muxOut.close();
    }
}

