/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RpcrSignalChanges {
    public String rpcrName;
    public ArrayList<String> signals;
    public boolean mux;

    public RpcrSignalChanges(File file) throws IOException {
        this.rpcrName = file.getName().substring(0, 4);
        this.signals = new ArrayList(500);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex);
            throw new IllegalArgumentException(ex.toString());
        }
        String line = null;
        int j = 0;
        while (j < 6) {
            line = in.readLine();
            ++j;
        }
        if (line != null) {
            this.mux = line.startsWith("      Signal Name");
        }
        while ((line = in.readLine()) != null) {
            String result = this.extractSignal(line);
            if (result == null) continue;
            this.signals.add(result);
        }
        in.close();
    }

    protected String extractSignal(String line) {
        StringTokenizer tok;
        block7: {
            tok = new StringTokenizer(line);
            if (tok.hasMoreTokens()) break block7;
            System.out.println("blank line");
            return null;
        }
        try {
            String changeSymbol = tok.nextToken();
            if (changeSymbol.equals("+") || changeSymbol.equals(">")) {
                if (!tok.nextToken().equals("is:")) {
                    throw new IllegalArgumentException("Ryan --> you didn't think of everyting. Duh!");
                }
                if (line.charAt(6) != ' ') {
                    if (this.mux) {
                        return line.substring(6, 25).trim();
                    }
                    tok.nextToken();
                    String elementName = tok.nextToken();
                    String lmName = tok.nextToken();
                    return "l_" + lmName.toLowerCase() + "__" + elementName.toLowerCase();
                }
            }
        }
        catch (NoSuchElementException ex) {
            System.out.println(ex + line);
            System.exit(1);
        }
        return null;
    }

    public boolean affectsLine(String line) {
        int i = 0;
        while (i < this.signals.size()) {
            if (line.indexOf(this.signals.get(i)) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

