/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Range;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;

public class ReplaceRcsLog {
    private static final Pattern logStartP = Pattern.compile("\\$Log.*\\s+");
    private static final Pattern revP = Pattern.compile("Revision \\d+\\.\\d+.*");
    private static final Pattern revEndP = Pattern.compile("\n[* \t/\\\\]*\n");

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java text.ReplaceRcsLog <dir for history> <dir for content> <result dir>");
            return;
        }
        ReplaceRcsLog app = new ReplaceRcsLog();
        app.replaceRcsLogs(new File(args[0]), new File(args[1]), new File(args[2]));
    }

    public void replaceRcsLogs(File directoryA, File directoryB, File resultDir) {
        File[] files = directoryA.listFiles(new MatchFilter(".*\\.(c|mac|h)"));
        int i = 0;
        while (i < files.length) {
            File fileB = new File(directoryB, files[i].getName());
            if (fileB.exists()) {
                this.replaceRcsLog(files[i], fileB, new File(resultDir, files[i].getName()));
            }
            ++i;
        }
    }

    public void replaceRcsLog(File historyFile, File contentFile, File resultFile) {
        try {
            CharBuffer historySeq = Lib.fileToCharBuffer(historyFile);
            Range historyRange = ReplaceRcsLog.findRcsLog(historySeq);
            CharBuffer contentSeq = Lib.fileToCharBuffer(contentFile);
            Range contentRange = ReplaceRcsLog.findRcsLog(contentSeq);
            ChangeSet changeSet = new ChangeSet(contentSeq);
            changeSet.replace(contentRange.start, contentRange.end, historySeq.array(), historyRange.start, historyRange.length);
            changeSet.applyChanges(resultFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        catch (IllegalArgumentException ex) {
            System.out.println(historyFile + ": " + ex.getMessage());
            return;
        }
    }

    public static Range findRcsLog(CharSequence seq) throws IllegalArgumentException {
        Matcher logStartM = logStartP.matcher(seq);
        if (!logStartM.find()) {
            throw new IllegalArgumentException(" is missing $Log");
        }
        int firstRevStartIndex = logStartM.end();
        Matcher revM = revP.matcher(seq);
        int lastRevStartIndex = 0;
        while (revM.find()) {
            lastRevStartIndex = revM.start();
        }
        Matcher revEndM = revEndP.matcher(seq);
        int lastRevEndIndex = 0;
        if (!revEndM.find(lastRevStartIndex)) {
            throw new IllegalArgumentException(" didn't find end of revision info");
        }
        lastRevEndIndex = revEndM.start() + 1;
        return new Range(firstRevStartIndex, lastRevEndIndex);
    }
}

