/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.change;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.osee.framework.jdk.core.text.change.CharacterChanger;

public class CharArrayChange
implements CharacterChanger {
    private final int srcStartIndex;
    private final int srcEndIndex;
    private char[] newChars;
    private final int offset;
    private final int length;
    private CharacterChanger next;

    public CharArrayChange(int srcStartIndex, int srcEndIndex, char[] newChars, int offset, int length, boolean copy) {
        this.srcStartIndex = srcStartIndex;
        this.srcEndIndex = srcEndIndex;
        if (copy) {
            this.newChars = new char[newChars.length];
            System.arraycopy(newChars, 0, this.newChars, 0, newChars.length);
        } else {
            this.newChars = newChars;
        }
        this.offset = offset;
        this.length = length;
    }

    public CharArrayChange(int srcStartIndex, int srcEndIndex, char[] newChars, int offset, int length) {
        this(srcStartIndex, srcEndIndex, newChars, offset, length, false);
    }

    public CharArrayChange(int srcStartIndex, int srcEndIndex, char[] newChars) {
        this(srcStartIndex, srcEndIndex, newChars, 0, newChars.length);
    }

    @Override
    public int getStartIndex() {
        return this.srcStartIndex;
    }

    @Override
    public int getEndIndex() {
        return this.srcEndIndex;
    }

    @Override
    public int applyChange(char[] dest, int destPos) {
        System.arraycopy(this.newChars, this.offset, dest, destPos, this.length);
        return destPos + this.length;
    }

    @Override
    public void applyChange(Writer writer) throws IOException {
        writer.write(this.newChars, this.offset, this.length);
    }

    @Override
    public CharacterChanger next() {
        return this.next;
    }

    @Override
    public void setNext(CharacterChanger next) {
        this.next = next;
    }

    @Override
    public int getLengthDelta() {
        return this.length - this.srcEndIndex + this.srcStartIndex;
    }
}

