/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.eclipse.osee.executor.admin.ExecutionCallback;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.mail.api.MailCallback;
import org.eclipse.osee.mail.api.MailMessage;
import org.eclipse.osee.mail.api.MailService;
import org.eclipse.osee.mail.api.MailStatus;
import org.eclipse.osee.mail.internal.MailConfiguration;
import org.eclipse.osee.mail.internal.MailMessageFactory;
import org.eclipse.osee.mail.internal.SendMailCallable;

public class MailServiceImpl
implements MailService {
    private static final MailCallback NO_OP_CALLBACK = null;
    private ExecutorAdmin executorAdmin;
    private Log logger;
    private MailMessageFactory factory;
    private volatile MailConfiguration config;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.initJavaxMailRuntime();
        AtomicInteger testCounter = new AtomicInteger();
        this.factory = new MailMessageFactory(this.logger, testCounter);
        this.update(props);
    }

    public void stop(Map<String, Object> props) {
        this.logger.trace("Stopping [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.factory = null;
        this.config = null;
    }

    public void update(Map<String, Object> props) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.config = MailConfiguration.newConfig(props);
    }

    private void initJavaxMailRuntime() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/*;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("multipart/mixed;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        mc.addMailcap("image/jpeg;; x-java-content-handler=com.sun.mail.handlers.image_jpeg");
        mc.addMailcap("image/gif;; x-java-content-handler=com.sun.mail.handlers.image_gif");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    private MailMessage newTestMailMessage() {
        String adminEmail = this.config.getAdminEmail();
        String subject = this.config.getTestEmailSubject();
        String body = this.config.getTestEmailBody();
        return this.factory.createTestMessage(adminEmail, subject, body);
    }

    public MailStatus sendTestMessage() {
        MailMessage message = this.newTestMailMessage();
        List<MailStatus> results = this.sendMessages(message);
        return results.isEmpty() ? null : results.iterator().next();
    }

    public Future<MailStatus> sendAsyncTestMessage() {
        return this.sendAsyncTestMessage(NO_OP_CALLBACK);
    }

    public Future<MailStatus> sendAsyncTestMessage(MailCallback callback) {
        MailMessage message = this.newTestMailMessage();
        List<Future<MailStatus>> results = this.sendAsyncMessages(callback, message);
        return results.isEmpty() ? null : results.iterator().next();
    }

    public List<MailStatus> sendMessages(MailMessage ... email) {
        return this.sendMessages(Arrays.asList(email));
    }

    public List<MailStatus> sendMessages(Iterable<MailMessage> emails) {
        List<Future<MailStatus>> futures = this.sendAsyncMessages(emails);
        ArrayList<MailStatus> toReturn = new ArrayList<MailStatus>();
        for (Future<MailStatus> future : futures) {
            toReturn.add(this.executeAndGetStatus(future));
        }
        return toReturn;
    }

    public List<Future<MailStatus>> sendAsyncMessages(MailMessage ... email) {
        return this.sendAsyncMessages(NO_OP_CALLBACK, email);
    }

    public List<Future<MailStatus>> sendAsyncMessages(Iterable<MailMessage> emails) {
        return this.sendAsyncMessages(NO_OP_CALLBACK, emails);
    }

    public List<Future<MailStatus>> sendAsyncMessages(MailCallback callback, MailMessage ... email) {
        return this.sendAsyncMessages(callback, Arrays.asList(email));
    }

    private MailStatus executeAndGetStatus(Future<MailStatus> future) {
        MailStatus toReturn;
        try {
            toReturn = future.get();
        }
        catch (Exception ex) {
            toReturn = new MailStatus();
            toReturn.setSubject(Lib.exceptionToString((Exception)ex));
        }
        return toReturn;
    }

    public List<Future<MailStatus>> sendAsyncMessages(MailCallback mailCallback, Iterable<MailMessage> emails) {
        ArrayList<Future<MailStatus>> futures = new ArrayList<Future<MailStatus>>();
        for (MailMessage mail : emails) {
            String uuid = mail.getId();
            Callable<MailStatus> callable = this.newSendCallable(mail);
            ExecutionCallback<MailStatus> callback = null;
            if (mailCallback != null) {
                callback = MailServiceImpl.newExecutionCallback(uuid, mailCallback);
            }
            try {
                Future future = this.executorAdmin.schedule(callable, callback);
                futures.add(future);
            }
            catch (Exception ex) {
                if (mailCallback != null) {
                    mailCallback.onFailure(uuid, (Throwable)ex);
                }
                this.logger.error((Throwable)ex, "Error sending email [%s] ", new Object[]{uuid});
            }
        }
        return futures;
    }

    private Callable<MailStatus> newSendCallable(MailMessage mail) {
        return new SendMailCallable(this.config, this.factory, mail);
    }

    private static ExecutionCallback<MailStatus> newExecutionCallback(final String mailId, final MailCallback mailCallback) {
        return new ExecutionCallback<MailStatus>(){

            public void onCancelled() {
                mailCallback.onCancelled(mailId);
            }

            public void onSuccess(MailStatus status) {
                mailCallback.onSuccess(mailId, status);
            }

            public void onFailure(Throwable throwable) {
                mailCallback.onFailure(mailId, throwable);
            }
        };
    }
}

