/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoProgamDescriptorData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.DispoAdminResource;
import org.eclipse.osee.disposition.rest.resources.DispoConfigResource;
import org.eclipse.osee.disposition.rest.resources.DispoSetResource;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="program")
public class DispoProgramResource {
    private final DispoApi dispoApi;

    public DispoProgramResource(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createProgram(DispoProgamDescriptorData programDescriptor) {
        Response response;
        String name = programDescriptor.getName();
        if (!name.isEmpty()) {
            boolean isUniqueName = this.dispoApi.isUniqueProgramName(name);
            if (isUniqueName) {
                long createdProgramId = this.dispoApi.createDispoProgram(name);
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdProgramId).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllPrograms() throws JSONException {
        List<IOseeBranch> allPrograms = this.dispoApi.getDispoPrograms();
        Collections.sort(allPrograms, new Comparator<IOseeBranch>(){

            @Override
            public int compare(IOseeBranch o1, IOseeBranch o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        JSONArray jarray = new JSONArray();
        for (IOseeBranch branch : allPrograms) {
            JSONObject jobject = new JSONObject();
            String uuid = branch.getIdString();
            jobject.put("value", (Object)uuid);
            jobject.put("text", (Object)branch.getName());
            jarray.put((Object)jobject);
        }
        Response.Status status = allPrograms.isEmpty() ? Response.Status.NOT_FOUND : Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)jarray.toString()).build();
    }

    @Path(value="{branchId}/set")
    public DispoSetResource getAnnotation(@PathParam(value="branchId") BranchId branch) {
        return new DispoSetResource(this.dispoApi, branch);
    }

    @Path(value="{branchId}/admin")
    public DispoAdminResource getDispoSetReport(@PathParam(value="branchId") BranchId branch) {
        return new DispoAdminResource(this.dispoApi, branch);
    }

    @Path(value="{branchId}/config")
    public DispoConfigResource getDispoDataStore(@PathParam(value="branchId") BranchId branch) {
        return new DispoConfigResource(this.dispoApi, branch);
    }
}

