/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.ResolutionMethod;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.LocationRangesCompressor;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class ExportSet {
    private final DispoApi dispoApi;
    private int totalStatementCount;
    private int totalCoveredCount;

    public ExportSet(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    public void runReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream) {
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            Object[] headers = ExportSet.getHeadersDetailed();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                DispoConnector connector = new DispoConnector();
                List<String> allUncoveredDiscprepancies = connector.getAllUncoveredDiscprepancies(item);
                List<Integer> allUncoveredDiscrepanciesAsInts = this.getDiscrepanciesAsInts(allUncoveredDiscprepancies);
                Object[] row = new String[columns];
                int index = 0;
                Map discrepanciesList = item.getDiscrepanciesList();
                row[index++] = String.valueOf(item.getName());
                row[index++] = String.valueOf(item.getCategory());
                row[index++] = String.valueOf(item.getStatus());
                row[index++] = String.valueOf(item.getTotalPoints());
                row[index++] = String.valueOf(item.getDiscrepanciesList().size());
                row[index++] = String.valueOf(DispoUtil.discrepanciesToString(discrepanciesList));
                row[index++] = String.valueOf(allUncoveredDiscprepancies.size());
                String uncoveredDiscrepancies = allUncoveredDiscrepanciesAsInts.isEmpty() ? DispoUtil.listToString(allUncoveredDiscprepancies) : LocationRangesCompressor.compress(allUncoveredDiscrepanciesAsInts);
                row[index++] = String.valueOf(uncoveredDiscrepancies);
                row[index++] = String.valueOf(item.getAssignee());
                row[index++] = String.valueOf(item.getTeam());
                row[index++] = String.valueOf(item.getItemNotes());
                row[index++] = String.valueOf(item.getNeedsRerun());
                row[index++] = String.valueOf(item.getAborted());
                row[index++] = String.valueOf(item.getMachine());
                row[index++] = String.valueOf(item.getElapsedTime());
                row[index++] = String.valueOf(item.getCreationDate());
                row[index++] = String.valueOf(item.getLastUpdate());
                row[index++] = String.valueOf(item.getVersion());
                row[index++] = String.valueOf(ExportSet.prettifyAnnotations(item.getAnnotationsList()));
                sheetWriter.writeRow(row);
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    public void runCoverageReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream) {
        this.totalStatementCount = 0;
        this.totalCoveredCount = 0;
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        HashMap<String, Integer> resolutionToCount = new HashMap<String, Integer>();
        HashMap<String, Pair<Integer, Integer>> unitToCovered = new HashMap<String, Pair<Integer, Integer>>();
        DispoConfig config = this.dispoApi.getDispoConfig(branch);
        config.getValidResolutions();
        for (ResolutionMethod resolution : config.getValidResolutions()) {
            resolutionToCount.put(resolution.getText(), 0);
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            Object[] headers = ExportSet.getHeadersCoverage();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                List annotations = item.getAnnotationsList();
                for (Object annotation : annotations) {
                    this.writeRowAnnotation(sheetWriter, columns, item, (DispoAnnotationData)annotation, setPrimary.getName(), resolutionToCount, unitToCovered, this.totalStatementCount);
                }
            }
            sheetWriter.endSheet();
            sheetWriter.startSheet("Cover Sheet", headers.length);
            Object[] coverSheetHeaders = new Object[]{" ", setPrimary.getName()};
            sheetWriter.writeRow(coverSheetHeaders);
            Object[] row = new String[]{"All Coverage Methods", this.getPercent(this.totalCoveredCount, this.totalStatementCount, false)};
            sheetWriter.writeRow(row);
            for (String resolution : resolutionToCount.keySet()) {
                row[0] = resolution;
                row[1] = this.getPercent((Integer)resolutionToCount.get(resolution), this.totalStatementCount, false);
                sheetWriter.writeRow(row);
            }
            sheetWriter.endSheet();
            Object[] summarySheetHeaders = new Object[]{"Unit", "Lines Covered", "Total Lines", "Percent Coverage"};
            sheetWriter.startSheet("Summary Sheet", summarySheetHeaders.length);
            sheetWriter.writeRow(summarySheetHeaders);
            Object[] row2 = new String[4];
            Iterator iterator = unitToCovered.keySet().iterator();
            while (iterator.hasNext()) {
                String unit;
                row2[0] = unit = (String)iterator.next();
                Pair coveredOverTotal = (Pair)unitToCovered.get(unit);
                int covered = (Integer)coveredOverTotal.getFirst();
                int total = (Integer)coveredOverTotal.getSecond();
                row2[1] = String.valueOf(covered);
                row2[2] = String.valueOf(total);
                Double percent = (double)covered / (double)total * 100.0;
                row2[3] = String.format("%2.2f%%", percent);
                sheetWriter.writeRow(row2);
            }
            sheetWriter.endSheet();
            Object[] testScriptSheetHeaders = new Object[]{"Unit", "Code Line", "Resolution Type", "Script Name", "Script Path", "Script Notes"};
            sheetWriter.startSheet("Test Script Sheet", testScriptSheetHeaders.length);
            sheetWriter.writeRow(testScriptSheetHeaders);
            for (DispoItem item : items) {
                List annotations = item.getAnnotationsList();
                for (DispoAnnotationData annotation : annotations) {
                    if (!annotation.getResolutionType().equals("Test_Script")) continue;
                    HashMap<String, String> testNameToPath = DispoUtil.splitTestScriptNameAndPath(Collections.singletonList(annotation));
                    sheetWriter.writeRow(new Object[]{item.getName(), annotation.getLocationRefs(), annotation.getResolutionType(), testNameToPath.keySet(), testNameToPath.values(), annotation.getResolution()});
                }
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private List<Integer> getDiscrepanciesAsInts(List<String> discrepancyLocations) {
        List<Integer> toReturn = new ArrayList<Integer>();
        for (String location : discrepancyLocations) {
            if (DispoUtil.isNumericLocations(location)) {
                toReturn.add(Integer.valueOf(location));
                continue;
            }
            toReturn = Collections.emptyList();
            break;
        }
        return toReturn;
    }

    private String getPercent(int complete, int total, boolean showZero) {
        if (total == 0 || complete == 0) {
            return this.getPercentString(0.0, complete, total, showZero);
        }
        Double percent = new Double(complete);
        percent = percent / (double)total;
        percent = percent * 100.0;
        return this.getPercentString(percent, complete, total, showZero);
    }

    private String getPercentString(double percent, int complete, int total, boolean showZero) {
        if (!showZero && percent == 0.0 && complete == 0) {
            return "0%";
        }
        if (percent == 100.0) {
            return String.format("100%% - %d / %d", complete, total);
        }
        if (percent == 0.0) {
            return String.format("0%% - %d / %d", complete, total);
        }
        return String.format("%2.2f%% - %d / %d", percent, complete, total);
    }

    private void writeRowAnnotation(ExcelXmlWriter sheetWriter, int columns, DispoItem item, DispoAnnotationData annotation, String setName, Map<String, Integer> resolutionToCount, Map<String, Pair<Integer, Integer>> unitToCovered, Integer totalNumber) throws IOException {
        int coveredCount;
        ++this.totalStatementCount;
        Object[] row = new String[columns];
        int index = 0;
        row[index++] = this.getNameSpace(item, setName);
        String unit = this.getNormalizedName(item.getName());
        row[index++] = unit;
        row[index++] = item.getName().replaceAll(".*\\.", "");
        row[index++] = String.valueOf(item.getMethodNumber());
        row[index++] = String.valueOf(annotation.getLocationRefs());
        String coverageMethod = annotation.getResolutionType();
        if (Strings.isValid((String)coverageMethod)) {
            row[index++] = coverageMethod;
            String rationale = annotation.getResolution();
            row[index++] = coverageMethod.equalsIgnoreCase("Test_Script") || !Strings.isValid((String)rationale) ? "N/A" : rationale;
        } else {
            row[index++] = "Uncovered";
            row[index++] = "N/A";
        }
        sheetWriter.writeRow(row);
        Integer count = resolutionToCount.get(coverageMethod);
        if (Strings.isValid((String)coverageMethod)) {
            if (count == null) {
                resolutionToCount.put(coverageMethod, 1);
            } else {
                count = count + 1;
                resolutionToCount.put(coverageMethod, count);
            }
        }
        Pair<Integer, Integer> coveredOverTotal = unitToCovered.get(unit);
        if (Strings.isValid((String)coverageMethod)) {
            coveredCount = 1;
            ++this.totalCoveredCount;
        } else {
            coveredCount = 0;
        }
        if (coveredOverTotal == null) {
            Pair newCount = new Pair((Object)coveredCount, (Object)1);
            unitToCovered.put(unit, (Pair<Integer, Integer>)newCount);
        } else {
            Integer currentCovered = (Integer)coveredOverTotal.getFirst();
            Integer currentTotal = (Integer)coveredOverTotal.getSecond();
            currentTotal = currentTotal + 1;
            Pair newCount = new Pair((Object)(currentCovered + coveredCount), (Object)currentTotal);
            unitToCovered.put(unit, (Pair<Integer, Integer>)newCount);
        }
    }

    private String getNormalizedName(String fullName) {
        if (fullName.contains(".2.ada")) {
            return fullName.replaceAll("\\.2\\.ada.*", ".2.ada");
        }
        return fullName.replaceAll("\\.c.*", ".c");
    }

    private String getNameSpace(DispoItem item, String setName) {
        Pattern pattern = Pattern.compile(".*?(\\..*?){1,}\\.2\\.ada");
        Matcher matcher = pattern.matcher(item.getName());
        StringBuilder nameSpace = new StringBuilder(setName);
        if (matcher.find()) {
            String str = matcher.group();
            Pattern pattern2 = Pattern.compile(".*\\.");
            Matcher matcher2 = pattern2.matcher(str.replaceAll("\\.2.*", ""));
            if (matcher2.find()) {
                nameSpace.append(".");
                String toAdd = matcher2.group();
                nameSpace.append(toAdd.substring(0, toAdd.length() - 1));
            }
        }
        return nameSpace.toString();
    }

    private static String prettifyAnnotations(List<DispoAnnotationData> annotations) {
        StringBuilder sb = new StringBuilder();
        for (DispoAnnotationData annotation : annotations) {
            sb.append(annotation.getLocationRefs());
            sb.append(":");
            sb.append(annotation.getResolution());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String[] getHeadersDetailed() {
        String[] toReturn = new String[]{"Script Name", "Category", "Status", "Total Test Points", "Failures", "Failed Points", "Remaining Count", "Remaining Points", "Assignee", "Team", "Item Notes", "Needs Rerun", "Aborted", "Station", "Elapsed Time", "Creation Date", "Last Updated", "Version", "Dispositions"};
        return toReturn;
    }

    private static String[] getHeadersCoverage() {
        String[] toReturn = new String[]{"Namespace", "Parent Coverage Unit", "Unit", "Method Number", "Execution Line Number", "Coverage Method", "Coverage Rationale"};
        return toReturn;
    }
}

