/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer.coverage;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.vcast.VCastClient;
import org.eclipse.osee.vcast.VCastDataStore;
import org.eclipse.osee.vcast.VCastLisFileParser;
import org.eclipse.osee.vcast.VCastValidateDatFileSyntax;
import org.eclipse.osee.vcast.model.VCastFunction;
import org.eclipse.osee.vcast.model.VCastInstrumentedFile;
import org.eclipse.osee.vcast.model.VCastResult;
import org.eclipse.osee.vcast.model.VCastSourceFileJoin;
import org.eclipse.osee.vcast.model.VCastStatementCoverage;

public class LisFileParser
implements DispoImporterApi {
    private static final String RESULTS = "results";
    private static final String IMPORTED_RESULTS = "IMPORTED_RESULTS";
    private static final String LOG = "\\s*(log).*";
    private static final String EXIT_WHEN = "\\s*\\( \\)\\s*\\( \\)\\s*(EXIT WHEN).*";
    private static final String WHEN_FOR = "\\s*\\( \\)\\s*(WHEN|FOR).*";
    private static final String WHEN_CASE = "(.*\\bWHEN\\b\\s*[^:]*$)";
    private static final String CASE_STATEMENT = "(.*(\\bCASE|case|default|\\s+.+[:].*))";
    private final DispoDataFactory dataFactory;
    private static final Pattern fileMethod5LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod3LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod4LineNumberPlusTokenPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+(T|F)");
    private final Map<String, DispoItemData> datIdToItem = new HashMap<String, DispoItemData>();
    private final Set<String> datIdsCoveredByException = new HashSet<String>();
    private final Set<String> alreadyUsedDatIds = new HashSet<String>();
    private final Set<String> alreadyUsedFileNames = new HashSet<String>();
    private final DispoConnector dispoConnector;
    private final DispoApiConfiguration config;
    private String vCastDir;

    public LisFileParser(Log logger, DispoDataFactory dataFactory, DispoApiConfiguration config, DispoConnector connector) {
        this.dataFactory = dataFactory;
        this.config = config;
        this.dispoConnector = connector;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File filesDir, OperationReport report) {
        this.vCastDir = String.valueOf(filesDir.getAbsolutePath()) + File.separator + "vcast";
        File f = new File(String.valueOf(this.vCastDir) + File.separator + "cover.db");
        VCastDataStore dataStore = VCastClient.newDataStore((String)f.getAbsolutePath());
        dataStore.setIsMCDC();
        dataStore.setIsBranch();
        Collection<VCastInstrumentedFile> instrumentedFiles = this.getInstrumentedFiles(dataStore, report);
        for (VCastInstrumentedFile instrumentedFile : instrumentedFiles) {
            this.processInstrumented(dataStore, instrumentedFile, report);
        }
        Collection<VCastResult> results = this.getResultFiles(dataStore);
        for (VCastResult result : results) {
            try {
                this.processResult(result, report);
            }
            catch (Exception exception) {
                report.addEntry("FAILURE", "VCast Error", DispoSummarySeverity.ERROR);
            }
        }
        this.processExceptionHandled(report);
        return this.createItems(exisitingItems, report);
    }

    private List<DispoItem> createItems(Map<String, DispoItem> exisitingItems, OperationReport report) {
        List<DispoItem> toReturn;
        Collection<DispoItemData> values = this.datIdToItem.values();
        for (DispoItemData dispoItemData : values) {
            this.dataFactory.initDispoItem(dispoItemData);
            dispoItemData.setTotalPoints(String.valueOf(dispoItemData.getAnnotationsList().size() + dispoItemData.getDiscrepanciesList().size()));
        }
        if (!exisitingItems.isEmpty()) {
            DispoSetCopier dispoSetCopier = new DispoSetCopier(this.dispoConnector);
            ArrayList<DispoItemData> itemsFromImport = new ArrayList<DispoItemData>();
            itemsFromImport.addAll(values);
            HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
            for (DispoItemData item : itemsFromImport) {
                String name = item.getName();
                Set itemsWithSameName = (Set)namesToDestItems.get(name);
                if (itemsWithSameName == null) {
                    HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                    set.add(item);
                    namesToDestItems.put(name, set);
                    continue;
                }
                itemsWithSameName.add(item);
                namesToDestItems.put(name, itemsWithSameName);
            }
            toReturn = dispoSetCopier.copyAllDispositions(namesToDestItems, exisitingItems.values(), false, null, report);
        } else {
            toReturn = new ArrayList<DispoItem>();
            toReturn.addAll(values);
        }
        for (DispoItem dispoItem : toReturn) {
            if (!dispoItem.getStatus().equalsIgnoreCase("incomplete")) continue;
            this.createPlaceHolderAnnotations((DispoItemData)dispoItem, report);
        }
        return toReturn;
    }

    private void createPlaceHolderAnnotations(DispoItemData item, OperationReport report) {
        List<String> uncovered = this.dispoConnector.getAllUncoveredDiscprepancies((DispoItem)item);
        if (!uncovered.isEmpty()) {
            Map discrepanciesList = item.getDiscrepanciesList();
            for (String id : discrepanciesList.keySet()) {
                Discrepancy discrepancy = (Discrepancy)discrepanciesList.get(id);
                if (!uncovered.contains(discrepancy.getLocation())) continue;
                this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText());
            }
        }
    }

    private void processExceptionHandled(OperationReport report) {
        for (String datId : this.datIdsCoveredByException) {
            Matcher matcher = Pattern.compile("\\d*:\\d*:").matcher(datId);
            matcher.find();
            String itemDatId = matcher.group();
            DispoItemData item = this.datIdToItem.get(itemDatId);
            String line = datId.replaceAll("\\d*:\\d*:", "");
            line = line.replaceAll(":", "");
            String text = "";
            Discrepancy matchingDiscrepancy = this.matchDiscrepancy(line, item.getDiscrepanciesList());
            if (matchingDiscrepancy == null) continue;
            text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            discrepancies.remove(matchingDiscrepancy.getId());
            this.addAnnotationForCoveredLine(item, line, "Exception_Handling", "", text);
        }
    }

    private Collection<VCastInstrumentedFile> getInstrumentedFiles(VCastDataStore dataStore, OperationReport report) {
        ArrayList<VCastInstrumentedFile> instrumentedFiles = new ArrayList();
        try {
            instrumentedFiles = dataStore.getAllInstrumentedFiles();
        }
        catch (OseeCoreException oseeCoreException) {
            report.addEntry("SQL", String.format("SQL error while reading functions for directory: [%s]", this.vCastDir), DispoSummarySeverity.ERROR);
        }
        return instrumentedFiles;
    }

    private void processInstrumented(VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, OperationReport report) {
        VCastSourceFileJoin sourceFile = null;
        try {
            sourceFile = dataStore.getSourceFileJoin(instrumentedFile);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading source_files for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        if (sourceFile != null) {
            int fileNum = sourceFile.getUnitIndex();
            String lisFileNameFullPath = instrumentedFile.getLISFile();
            if (!Strings.isValid((String)lisFileNameFullPath)) {
                report.addEntry("SQL", String.format("Error: instrumented_file has invalid LIS_file value.  ID:(" + instrumentedFile.getId() + ")", new Object[0]), DispoSummarySeverity.ERROR);
            }
            String normalizedPath = lisFileNameFullPath.replaceAll("\\\\", "/");
            File lisFile = new File(normalizedPath);
            String lisFileName = lisFile.getName();
            VCastLisFileParser lisFileParser = new VCastLisFileParser(lisFileName, this.vCastDir);
            Collection<Object> functions = Collections.emptyList();
            try {
                functions = dataStore.getFunctions(instrumentedFile);
            }
            catch (OseeCoreException oseeCoreException) {
                report.addEntry("SQL", String.format("SQL error while reading functions for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), oseeCoreException.getMessage()), DispoSummarySeverity.ERROR);
            }
            for (VCastFunction vCastFunction : functions) {
                this.processFunction(instrumentedFile, lisFileParser, fileNum, dataStore, instrumentedFile, vCastFunction, dataStore.getIsMCDC(), report);
            }
        }
    }

    private void processFunction(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, VCastFunction function, boolean isMCDCFile, OperationReport report) {
        int functionNum = function.getFindex();
        DispoItemData newItem = new DispoItemData();
        newItem.setAnnotationsList(new ArrayList());
        VCastSourceFileJoin sourceFileJoin = dataStore.getSourceFileJoin(lisFile);
        newItem.setName(String.valueOf(sourceFileJoin.getDisplayName()) + "." + function.getName());
        newItem.setFileNumber(Integer.toString(fileNum));
        newItem.setMethodNumber(Integer.toString(functionNum));
        try {
            String fileName = sourceFileJoin.getDisplayName();
            String fullPathToFile = String.valueOf(this.vCastDir) + File.separator + fileName.replaceAll(this.config.getFileExtRegex(), ".LIS");
            Date lastModified = DispoUtil.getTimestampOfFile(fullPathToFile);
            newItem.setLastUpdate(lastModified);
        }
        catch (Throwable ex) {
            report.addEntry("Get Timestamp of File", String.format("Error retrieving the timestamp for [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String datId = this.generateDatId(fileNum, functionNum);
        this.datIdToItem.put(datId, newItem);
        Collection<Object> statementCoverageItems = Collections.emptyList();
        try {
            statementCoverageItems = dataStore.getStatementCoverageLines(function);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading statement_coverages for instrumented_file id: [%s] and function id: [%s]. Error Message: [%s]", instrumentedFile.getId(), function.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        HashMap<String, Discrepancy> discrepancies = new HashMap<String, Discrepancy>();
        for (VCastStatementCoverage vCastStatementCoverage : statementCoverageItems) {
            this.processStatement(lisFile, lisFileParser, fileNum, functionNum, function, vCastStatementCoverage, isMCDCFile, discrepancies, report);
        }
        newItem.setDiscrepanciesList(discrepancies);
    }

    private void processStatement(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, int functionNum, VCastFunction function, VCastStatementCoverage statementCoverageItem, boolean isMCDCFile, Map<String, Discrepancy> discrepancies, OperationReport report) {
        Integer functionNumber = function.getFindex();
        Integer lineNumber = statementCoverageItem.getLine();
        Pair lineData = null;
        try {
            lineData = lisFileParser.getSourceCodeForLine(functionNumber, lineNumber);
        }
        catch (Exception ex) {
            report.addEntry("SQL", String.format("Issue getting source code line [%s], [%s]", lisFile.getLISFile(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String location = "";
        if (lineData != null) {
            boolean isMCDCPair = statementCoverageItem.getIsMCDCPair();
            if (isMCDCPair) {
                location = String.format("%s.%s.%s", lineNumber, statementCoverageItem.getAbbrevCondition(), "T");
                String location2 = String.format("%s.%s.%s", lineNumber, statementCoverageItem.getAbbrevCondition(), "F");
                if (!((String)lineData.getFirst()).matches(WHEN_FOR) && !((String)lineData.getFirst()).matches(CASE_STATEMENT)) {
                    String text = statementCoverageItem.getFullCondition();
                    this.addDiscrepancy(discrepancies, location, text);
                    this.addDiscrepancy(discrepancies, location2, text);
                } else {
                    String text = ((String)lineData.getFirst()).trim();
                    this.addDiscrepancy(discrepancies, location, text);
                }
            } else {
                String text = ((String)lineData.getFirst()).trim();
                if (statementCoverageItem.getNumConditions() == 2) {
                    location = String.format("%s.%s", lineNumber, "T");
                    String locationF = String.format("%s.%s", lineNumber, "F");
                    if (!(((String)lineData.getFirst()).matches(WHEN_FOR) || ((String)lineData.getFirst()).matches(EXIT_WHEN) || ((String)lineData.getFirst()).matches(LOG))) {
                        this.addDiscrepancy(discrepancies, location, text);
                        this.addDiscrepancy(discrepancies, locationF, text);
                    } else {
                        this.addDiscrepancy(discrepancies, location, text);
                    }
                } else if (statementCoverageItem.getNumConditions() == 1 && ((String)lineData.getFirst()).matches(WHEN_CASE)) {
                    location = String.format("%s.%s", lineNumber, "T");
                    this.addDiscrepancy(discrepancies, location, text);
                } else {
                    location = String.valueOf(lineNumber);
                    this.addDiscrepancy(discrepancies, location, text);
                }
            }
            if (((Boolean)lineData.getSecond()).booleanValue()) {
                String datId = this.generateDatId(fileNum, functionNum, location);
                this.datIdsCoveredByException.add(datId);
            }
        }
    }

    private void addDiscrepancy(Map<String, Discrepancy> discrepancies, String location, String text) {
        Discrepancy newDiscrepancy = new Discrepancy();
        newDiscrepancy.setLocation(location);
        newDiscrepancy.setText(text);
        String id = String.valueOf(Lib.generateUuid());
        newDiscrepancy.setId(id);
        discrepancies.put(id, newDiscrepancy);
    }

    private String generateDatId(Object ... ids) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            sb.append(id);
            sb.append(":");
            ++n2;
        }
        return sb.toString();
    }

    private void processResult(VCastResult result, OperationReport report) throws Exception {
        String resultPath = result.getPath();
        String resultPathAbs = String.valueOf(this.vCastDir) + File.separator + resultPath;
        File resultsFile = new File(resultPathAbs);
        if (!resultsFile.exists()) {
            boolean fileExists = this.findAndProcessResultFile(resultsFile, resultPath, report);
            if (!fileExists) {
                report.addEntry("SQL", String.format("Could not find DAT file [%s]", resultPathAbs), DispoSummarySeverity.WARNING);
            }
        } else {
            this.process(report, resultPath, resultsFile);
        }
    }

    private boolean findAndProcessResultFile(File resultsFile, String resultPath, OperationReport report) {
        ArrayList<File> resultsDirs = new ArrayList<File>();
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS));
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS + File.separator + IMPORTED_RESULTS));
        for (File resultsDir : resultsDirs) {
            File[] files;
            File[] fileArray = files = resultsDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String inputF = file.toString();
                String outputF = inputF.replaceAll(this.config.getResultsFileExtRegex(), "");
                if (outputF.toString().equalsIgnoreCase(resultsFile.toString())) {
                    this.process(report, resultPath, file);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void process(OperationReport report, String resultPath, File resultsFile) {
        block11: {
            if (!this.isDuplicateFile(resultsFile, report)) {
                BufferedReader br = null;
                try {
                    try {
                        String resultsLine;
                        br = new BufferedReader(new FileReader(resultsFile));
                        while ((resultsLine = br.readLine()) != null) {
                            Matcher m;
                            if (!Strings.isValid((String)resultsLine)) continue;
                            Result datFileSyntaxResult = VCastValidateDatFileSyntax.validateDatFileSyntax((String)resultsLine);
                            if (!datFileSyntaxResult.isTrue()) {
                                report.addEntry("SQL", String.format("This line [%s] is not in proper format. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
                                continue;
                            }
                            if (this.alreadyUsedDatIds.contains(resultsLine)) continue;
                            this.alreadyUsedDatIds.add(resultsLine);
                            StringTokenizer st = new StringTokenizer(resultsLine);
                            int count = st.countTokens();
                            if (count == 3) {
                                m = fileMethod3LineNumberPattern.matcher(resultsLine);
                                if (!m.find()) continue;
                                this.processSingleResult(resultPath, m);
                                continue;
                            }
                            if (count == 4) {
                                m = fileMethod4LineNumberPlusTokenPattern.matcher(resultsLine);
                                if (!m.find()) continue;
                                this.processSingleResultBranch(resultPath, m);
                                continue;
                            }
                            if (count == 5) {
                                m = fileMethod5LineNumberPattern.matcher(resultsLine);
                                if (!m.find()) continue;
                                this.processMultiResultMCDC(resultPath, m);
                                continue;
                            }
                            report.addEntry("RESULTS FILE PARSE", String.format("This line [%s] could not be parsed. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
                        }
                    }
                    catch (Exception ex) {
                        report.addEntry("EXCEPTION", ex.getMessage(), DispoSummarySeverity.ERROR);
                        Lib.close((Closeable)br);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(br);
                    throw throwable;
                }
                Lib.close((Closeable)br);
            }
        }
    }

    private boolean isDuplicateFile(File file, OperationReport report) {
        String normalizedFileName = file.getName().replaceAll("//....", "");
        if (this.alreadyUsedFileNames.contains(normalizedFileName)) {
            report.addEntry(file.getName(), "Duplicate File skipped", DispoSummarySeverity.WARNING);
            return true;
        }
        this.alreadyUsedFileNames.add(normalizedFileName);
        return false;
    }

    private void processSingleResult(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            String location = m.group(3);
            String text = "";
            Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
            if (matchingDiscrepancy != null) {
                text = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                discrepancies.remove(matchingDiscrepancy.getId());
                item.setDiscrepanciesList(discrepancies);
                this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
            }
        }
    }

    private void processSingleResultBranch(String resultPath, Matcher m) {
        String location;
        Discrepancy matchingDiscrepancy;
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null && (matchingDiscrepancy = this.matchDiscrepancy(location = String.valueOf(m.group(3)) + "." + m.group(4), item.getDiscrepanciesList())) != null) {
            String text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            discrepancies.remove(matchingDiscrepancy.getId());
            item.setDiscrepanciesList(discrepancies);
            this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
        }
    }

    private void processMultiResultMCDC(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            Integer lineNumber = Integer.valueOf(m.group(3));
            Integer bitsTrue = Integer.valueOf(m.group(4));
            Integer bitsUsed = Integer.valueOf(m.group(5));
            Map<String, Boolean> bitsTrueMap = this.getBitToBoolean(Integer.toString(bitsTrue, 2), Integer.toString(bitsUsed, 2));
            for (String abbrevCond : bitsTrueMap.keySet()) {
                String TorF = bitsTrueMap.get(abbrevCond) != false ? "T" : "F";
                String location = this.formatLocation(lineNumber, abbrevCond, TorF);
                Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
                if (matchingDiscrepancy == null) continue;
                String text = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                discrepancies.remove(matchingDiscrepancy.getId());
                item.setDiscrepanciesList(discrepancies);
                this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
            }
        }
    }

    private String formatLocation(int lineNumber, String abbrevCond, String TorF) {
        if (abbrevCond.length() != 1 || abbrevCond.charAt(0) < 'A' || abbrevCond.charAt(0) > 'Z') {
            return String.format("%s.%s.%s", lineNumber, abbrevCond, TorF);
        }
        return String.format("%s.%s.%s", lineNumber, String.valueOf(abbrevCond.charAt(0) - 64) + " (" + abbrevCond + ")", TorF);
    }

    private Map<String, Boolean> getBitToBoolean(String bitsTrue, String bitsUsed) {
        HashMap<String, Boolean> toReturn = new HashMap<String, Boolean>();
        char[] bitsUsedArray = bitsUsed.toCharArray();
        char[] bitsTrueArray = bitsTrue.toCharArray();
        int totalResultIndex = bitsTrueArray.length - 1;
        int sizeDelta = bitsUsedArray.length - bitsTrueArray.length;
        int highestChar = 63 + bitsUsedArray.length;
        int i = 1;
        while (i <= sizeDelta) {
            char c = (char)highestChar--;
            String key = Character.toString(c);
            toReturn.put(key, false);
            ++i;
        }
        i = 0;
        while (i < bitsTrueArray.length) {
            char valueC = bitsTrueArray[i];
            if (i != totalResultIndex) {
                char c = (char)highestChar--;
                String key = Character.toString(c);
                toReturn.put(key, valueC == '1');
            } else {
                toReturn.put("RESULT", valueC == '1');
            }
            ++i;
        }
        return toReturn;
    }

    private Discrepancy matchDiscrepancy(String location, Map<String, Discrepancy> discrepancies) {
        Discrepancy toReturn = null;
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            if (!String.valueOf(discrepancy.getLocation()).equals(location)) continue;
            toReturn = discrepancy;
            break;
        }
        return toReturn;
    }

    private void addBlankAnnotationForUncoveredLine(DispoItemData item, String location, String text) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(false);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType("");
        newAnnotation.setResolution("");
        newAnnotation.setIsResolutionValid(false);
        newAnnotation.setCustomerNotes(text);
        this.dispoConnector.connectAnnotation(newAnnotation, item.getDiscrepanciesList());
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private void addAnnotationForCoveredLine(DispoItemData item, String location, String resolutionType, String coveringFile, String text) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(true);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType(resolutionType);
        newAnnotation.setResolution(coveringFile);
        newAnnotation.setIsResolutionValid(true);
        newAnnotation.setCustomerNotes(text);
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private Collection<VCastResult> getResultFiles(VCastDataStore dataStore) {
        Collection results = null;
        results = dataStore.getAllResults();
        return results;
    }
}

