/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoItemDataCopier;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TmzImporter
implements DispoImporterApi {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy H:mm:ss aa", Locale.US);
    private final Log logger;
    private final DispoDataFactory dataFactory;

    public TmzImporter(Log logger, DispoDataFactory dataFactory) {
        this.logger = logger;
        this.dataFactory = dataFactory;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File filesDir, OperationReport report) {
        File[] files;
        LinkedList<DispoItem> toReturn = new LinkedList<DispoItem>();
        if (!filesDir.exists() || !filesDir.isDirectory()) {
            throw new OseeArgumentException("Input directory does not exists or is not a directory [%s]", new Object[]{filesDir.getAbsolutePath()});
        }
        File[] fileArray = files = filesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return Lib.getExtension((String)pathname.getName()).equals("tmz");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                File file = fileArray[n2];
                String scriptName = file.getName().replaceAll("\\..*", "");
                DispoItem oldItem = exisitingItems.get(scriptName);
                Date lastUpdate = oldItem != null ? oldItem.getLastUpdate() : new Date(0L);
                DispoItemData itemToBuild = null;
                HashMap<String, Discrepancy> discrepancies = null;
                ZipFile zf = null;
                try {
                    try {
                        zf = new ZipFile(file);
                        ZipEntry entry = zf.getEntry("Overview.json");
                        if (entry != null) {
                            InputStream inputStream = zf.getInputStream(entry);
                            String json = Lib.inputStreamToString((InputStream)inputStream);
                            itemToBuild = new DispoItemData();
                            itemToBuild.setName(scriptName);
                            this.processOverview(json, itemToBuild);
                            if (oldItem == null || !itemToBuild.getLastUpdate().after(lastUpdate)) {
                                discrepancies = new HashMap<String, Discrepancy>();
                                itemToBuild.setDiscrepanciesList(discrepancies);
                                entry = zf.getEntry("TestPointSummary.json");
                                if (entry != null) {
                                    inputStream = zf.getInputStream(entry);
                                    json = Lib.inputStreamToString((InputStream)inputStream);
                                    this.processTestPointSummary(json, discrepancies);
                                }
                                if (oldItem != null) {
                                    DispoItemDataCopier.copyOldItemData(oldItem, itemToBuild, report);
                                } else {
                                    this.dataFactory.initDispoItem(itemToBuild);
                                }
                                toReturn.add((DispoItem)itemToBuild);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger.info((Throwable)ex, "Unable to process: [%s]", new Object[]{file.getAbsolutePath()});
                        if (zf != null) {
                            try {
                                zf.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (Exception exception) {}
                }
            }
            ++n2;
        }
        return toReturn;
    }

    private void processOverview(String json, DispoItemData dispoItem) throws JSONException, ParseException {
        JSONObject record = new JSONObject(json);
        JSONObject properties = record.getJSONObject("properties");
        dispoItem.setVersion(properties.getString("version_revision"));
        Date date = DATE_FORMAT.parse(properties.getString("version_lastModificationDate"));
        dispoItem.setCreationDate(date);
        dispoItem.setLastUpdate(date);
    }

    private void processTestPointSummary(String json, Map<String, Discrepancy> discrepancies) throws JSONException {
        JSONObject contents = new JSONObject(json);
        JSONArray records = contents.getJSONArray("childRecords");
        int i = 0;
        while (i < records.length()) {
            JSONObject record = records.getJSONObject(i);
            String number = record.getString("number");
            JSONObject testPoint = record.getJSONObject("testPoint");
            boolean passed = testPoint.getBoolean("pass");
            if (!passed) {
                Discrepancy discrepancy = new Discrepancy();
                discrepancy.setLocation(number);
                String id = GUID.create();
                discrepancy.setId(id);
                boolean groupNameIsNull = testPoint.isNull("groupName");
                if (groupNameIsNull) {
                    String name = testPoint.getString("testPointName");
                    String actual = testPoint.getString("actual");
                    String expected = testPoint.getString("expected");
                    String text = String.format("Failure at Test Point %s. Check Point: %s. Expected: %s. Actual: %s. ", number, name, expected, actual);
                    discrepancy.setText(text);
                } else {
                    JSONArray testPoints = testPoint.getJSONArray("testPoints");
                    StringBuilder text = new StringBuilder(String.format("Failure at Test Point %s. Check Group with Checkpoint Failures: ", number));
                    int j = 0;
                    while (j < testPoints.length()) {
                        JSONObject checkPoint = testPoints.getJSONObject(j);
                        String name = checkPoint.getString("testPointName");
                        String actual = checkPoint.getString("actual");
                        String expected = checkPoint.getString("expected");
                        text.append(String.format("Check Point: %s. Expected: %s. Actual: %s. ", name, expected, actual));
                        ++j;
                    }
                    discrepancy.setText(text.toString());
                }
                discrepancies.put(id, discrepancy);
            }
            ++i;
        }
    }
}

