/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.internal.LocationRangesCompressor;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class DispoItemDataCopier {
    public static void copyOldItemData(DispoItem sourceItem, DispoItemData destItem, OperationReport report) {
        StringBuilder message = new StringBuilder();
        Map destItemDiscrepancies = destItem.getDiscrepanciesList();
        List sourceAnnotations = sourceItem.getAnnotationsList();
        Boolean needsReview = false;
        HashMap<String, String> idsToUpdate = DispoItemDataCopier.matchupOldDiscrepancies(sourceItem.getDiscrepanciesList(), destItemDiscrepancies, sourceAnnotations, message, needsReview);
        DispoItemDataCopier.updateTestPointNumbersForAnntations(idsToUpdate, sourceAnnotations, destItemDiscrepancies, message);
        destItem.setAnnotationsList(sourceAnnotations);
        report.addEntry(destItem.getName(), message.toString(), DispoSummarySeverity.UPDATE);
    }

    private static void updateTestPointNumbersForAnntations(HashMap<String, String> idsToUpdate, List<DispoAnnotationData> annotations, Map<String, Discrepancy> discrepancies, StringBuilder message) {
        for (DispoAnnotationData annotation : annotations) {
            List idsOfCoveredDiscrepancies = annotation.getIdsOfCoveredDiscrepancies();
            DispoItemDataCopier.updateIdsCoveredDiscrepancies(idsToUpdate, idsOfCoveredDiscrepancies, annotations, discrepancies, annotation, message);
        }
    }

    private static void updateIdsCoveredDiscrepancies(HashMap<String, String> idsToUpdate, List<String> idsOfCoveredDiscrepancies, List<DispoAnnotationData> annotations, Map<String, Discrepancy> discrepancies, DispoAnnotationData annotation, StringBuilder message) {
        for (String coveredId : idsOfCoveredDiscrepancies) {
            if (!idsToUpdate.containsKey(coveredId)) continue;
            String newLocRef = DispoItemDataCopier.rebuildLocRef(idsOfCoveredDiscrepancies, discrepancies, idsToUpdate, message);
            if (!newLocRef.isEmpty()) {
                annotation.setLocationRefs(newLocRef);
            }
            annotations.set(annotation.getIndex(), annotation);
            break;
        }
    }

    private static String rebuildLocRef(List<String> idsOfCoveredDiscrepancies, Map<String, Discrepancy> discrepancies, HashMap<String, String> idsToUpdate, StringBuilder message) {
        boolean isGaveup = false;
        ArrayList<Integer> testPointNumber = new ArrayList<Integer>();
        for (String id : idsOfCoveredDiscrepancies) {
            if (discrepancies.containsKey(id)) {
                Discrepancy discrepancy = discrepancies.get(id);
                String location = discrepancy.getLocation();
                testPointNumber.add(Integer.parseInt(location));
                continue;
            }
            if (idsToUpdate.containsKey(id)) {
                String justTestPoint = idsToUpdate.get(id);
                testPointNumber.add(Integer.parseInt(justTestPoint));
                continue;
            }
            message.append("Something when wrong with trying to rebuild the Annotations");
            isGaveup = true;
            break;
        }
        Collections.sort(testPointNumber);
        String toReturn = isGaveup ? "" : LocationRangesCompressor.compress(testPointNumber);
        return toReturn;
    }

    private static HashMap<String, String> matchupOldDiscrepancies(Map<String, Discrepancy> oldDiscrepancies, Map<String, Discrepancy> newDiscrepancies, List<DispoAnnotationData> annotations, StringBuilder message, Boolean needsReview) {
        HashMap<String, Pair<Discrepancy, Boolean>> textToNewDiscrepancies = DispoItemDataCopier.createTextToDiscrepanciesMap(newDiscrepancies);
        HashMap<String, String> idsToUpdate = new HashMap<String, String>();
        for (String key : oldDiscrepancies.keySet()) {
            Discrepancy oldDiscrepany = oldDiscrepancies.get(key);
            String normalizedText = oldDiscrepany.getText().replaceFirst(".*?\\.", "");
            Pair<Discrepancy, Boolean> matchedPair = textToNewDiscrepancies.get(normalizedText);
            String oldTestPointLocation = oldDiscrepany.getLocation();
            if (matchedPair != null) {
                Discrepancy matchedNewDiscrepancy = (Discrepancy)matchedPair.getFirst();
                if (((Boolean)matchedPair.getSecond()).booleanValue()) {
                    needsReview = true;
                }
                String idToReplace = matchedNewDiscrepancy.getId();
                String idOfOldDiscrep = oldDiscrepany.getId();
                matchedNewDiscrepancy.setId(idOfOldDiscrep);
                String newTestPointLocation = matchedNewDiscrepancy.getLocation();
                if (!oldTestPointLocation.equals(newTestPointLocation)) {
                    message.append("Test Point:");
                    message.append(oldTestPointLocation);
                    message.append("is now:");
                    message.append(newTestPointLocation);
                    idsToUpdate.put(idOfOldDiscrep, newTestPointLocation);
                }
                newDiscrepancies.remove(idToReplace);
                newDiscrepancies.put(idOfOldDiscrep, matchedNewDiscrepancy);
                continue;
            }
            message.append("Test Point:");
            message.append(oldTestPointLocation);
            message.append("No longer fails");
            String outdatedLocation = "-" + oldTestPointLocation;
            idsToUpdate.put("Deleted Discrepancy" + outdatedLocation, outdatedLocation);
            DispoItemDataCopier.removeDiscrepancyFromAnnotation(oldDiscrepany, annotations);
        }
        return idsToUpdate;
    }

    private static void removeDiscrepancyFromAnnotation(Discrepancy toRemove, List<DispoAnnotationData> annotations) {
        for (DispoAnnotationData annotation : annotations) {
            List idsOfCoveredDiscrepancies = annotation.getIdsOfCoveredDiscrepancies();
            if (idsOfCoveredDiscrepancies.toString().contains(toRemove.getId())) {
                DispoItemDataCopier.replaceIdInList(toRemove, idsOfCoveredDiscrepancies);
                annotation.setIsConnected(false);
            }
            annotations.set(annotation.getIndex(), annotation);
        }
    }

    private static void replaceIdInList(Discrepancy discrepany, List<String> idsList) {
        String id = discrepany.getId();
        int i = 0;
        while (i < idsList.size()) {
            if (id.equals(idsList.get(i))) {
                String testPoint = "-" + discrepany.getLocation();
                String newFakeId = "Deleted Discrepancy" + testPoint;
                idsList.add(i, newFakeId);
                break;
            }
            ++i;
        }
    }

    private static HashMap<String, Pair<Discrepancy, Boolean>> createTextToDiscrepanciesMap(Map<String, Discrepancy> discrepancies) {
        HashMap<String, Pair<Discrepancy, Boolean>> textToDiscrepancy = new HashMap<String, Pair<Discrepancy, Boolean>>();
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            String normalizedText = discrepancy.getText().replaceFirst(".*?\\.", "");
            Pair newPair = new Pair((Object)discrepancy, (Object)textToDiscrepancy.containsKey(normalizedText));
            textToDiscrepancy.put(normalizedText, (Pair<Discrepancy, Boolean>)newPair);
        }
        return textToDiscrepancy;
    }
}

