/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoStorageMetadata;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.internal.DispoConfigArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoItemArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoSetArtifact;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageUtil;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrcsStorageImpl
implements Storage {
    private final Log logger;
    private final OrcsApi orcsApi;

    public OrcsStorageImpl(Log logger, OrcsApi orcsApi) {
        this.logger = logger;
        this.orcsApi = orcsApi;
    }

    private ArtifactReadable getDispoUser() throws OseeCoreException {
        return (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)SystemUser.OseeSystem)).getResults().getExactlyOne();
    }

    private QueryFactory getQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private TransactionFactory getTxFactory() {
        return this.orcsApi.getTransactionFactory();
    }

    private OrcsBranch getBranchFactory() {
        return this.orcsApi.getBranchOps();
    }

    private void reloadTypes() {
        this.orcsApi.getOrcsTypes().invalidateAll();
    }

    @Override
    public boolean typesExist() {
        try {
            return ((QueryBuilder)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)DispoConstants.DISPO_ARTIFACT)).getResults().getAtMostOneOrNull() != null;
        }
        catch (OseeCoreException ex) {
            this.logger.warn((Throwable)ex, "Error checking for Dispo Types", new Object[0]);
            return false;
        }
    }

    @Override
    public void storeTypes(IResource resource) {
        TransactionBuilder tx = this.getTxFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)this.getDispoUser(), "Initialize Dispo Types");
        ArtifactToken artifactId = tx.createArtifact(DispoConstants.DISPO_ARTIFACT);
        InputStream stream = null;
        try {
            stream = resource.getContent();
            tx.setSoleAttributeFromStream((ArtifactId)artifactId, (AttributeTypeId)CoreAttributeTypes.UriGeneralStringData, stream);
        }
        finally {
            Lib.close((Closeable)stream);
        }
        tx.commit();
        this.reloadTypes();
    }

    @Override
    public ArtifactReadable findUser() {
        return (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)SystemUser.OseeSystem)).getResults().getExactlyOne();
    }

    @Override
    public ArtifactReadable findUser(String userId) {
        return (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andGuid(userId)).getResults().getExactlyOne();
    }

    @Override
    public ArtifactReadable findUnassignedUser() {
        return (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andNameEquals("UnAssigned")).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User})).getResults().getExactlyOne();
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        ResultSet results = ((BranchQuery)this.getQuery().branchQuery().andNameEquals(name)).getResults();
        return results.isEmpty();
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        ResultSet results = ((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispoSet})).andNameEquals(name)).getResults();
        return results.isEmpty();
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        ResultSet results = ((QueryBuilder)((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch(branch).andRelatedTo(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)setArt)).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispoItem})).andNameEquals(name)).getResults();
        return results.isEmpty();
    }

    @Override
    public List<DispoSet> findDispoSets(BranchId branch, String type) {
        ResultSet results = ((QueryBuilder)this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispoSet})).getResults();
        ArrayList<DispoSet> toReturn = new ArrayList<DispoSet>();
        for (ArtifactReadable art : results) {
            DispoSetArtifact dispoSetArt = new DispoSetArtifact(art);
            if (!dispoSetArt.getDispoType().equals(type)) continue;
            toReturn.add(dispoSetArt);
        }
        return toReturn;
    }

    @Override
    public DispoSet findDispoSetsById(BranchId branch, String setId) {
        ArtifactReadable result = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        return new DispoSetArtifact(result);
    }

    private ArtifactReadable findDispoArtifact(BranchId branch, String artId, IArtifactType type) {
        return (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branch).andUuid(Long.valueOf(artId).longValue())).getResults().getOneOrNull();
    }

    @Override
    public List<DispoItem> findDipoItems(BranchId branch, String setId, boolean isDetailed) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        ResultSet results = setArt.getChildren();
        ArrayList<DispoItem> toReturn = new ArrayList<DispoItem>();
        for (ArtifactReadable art : results) {
            DispoItemArtifact dispoItemArtifact = new DispoItemArtifact(art);
            dispoItemArtifact.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItemArtifact);
        }
        return toReturn;
    }

    @Override
    public Long createDispoProgram(ArtifactReadable author, String name) {
        String normalizedName = "(DISPO)" + name;
        BranchReadable dispoBranch = (BranchReadable)((BranchQuery)this.getQuery().branchQuery().andNameEquals("Dispo Parent")).getResults().getExactlyOne();
        IOseeBranch branch = IOseeBranch.create((String)normalizedName);
        try {
            this.getBranchFactory().createWorkingBranch(branch, (ArtifactId)author, (IOseeBranch)dispoBranch, ArtifactId.SENTINEL).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return branch.getGuid();
    }

    @Override
    public Long createDispoSet(ArtifactReadable author, BranchId branch, DispoSet descriptor) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Create Dispo Set");
        ArtifactToken creatdArtId = tx.createArtifact(DispoConstants.DispoSet, descriptor.getName());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.ImportPath, descriptor.getImportPath());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.ImportState, descriptor.getImportState());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.DispoType, descriptor.getDispoType());
        JSONArray notesJarray = DispoUtil.noteListToJsonObj(descriptor.getNotesList());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.DispoNotesJson, notesJarray.toString());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.DispoCiSet, descriptor.getCiSet());
        tx.setSoleAttributeFromString((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.DispoRerunList, descriptor.getRerunList());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeId)DispoConstants.DispoTime, (Object)descriptor.getTime());
        tx.commit();
        return creatdArtId.getUuid();
    }

    @Override
    public boolean deleteDispoItem(ArtifactReadable author, BranchId branch, String itemId) {
        return this.deleteDispoEntityArtifact(author, branch, itemId, DispoConstants.DispoItem);
    }

    @Override
    public boolean deleteDispoSet(ArtifactReadable author, BranchId branch, String setId) {
        return this.deleteDispoEntityArtifact(author, branch, setId, DispoConstants.DispoSet);
    }

    private boolean deleteDispoEntityArtifact(ArtifactReadable author, BranchId branch, String entityId, IArtifactType type) {
        boolean toReturn = false;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, entityId, type);
        if (dispoArtifact != null) {
            TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Delete Dispo Artifact");
            tx.deleteArtifact((ArtifactId)dispoArtifact);
            tx.commit();
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public void updateDispoSet(ArtifactReadable author, BranchId branch, String setId, DispoSet newData) {
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        DispoSetArtifact origSetAs = new DispoSetArtifact(dispoSet);
        String name = newData.getName();
        String importPath = newData.getImportPath();
        String ciSet = newData.getCiSet();
        String rerunList = newData.getRerunList();
        Date time = newData.getTime();
        JSONArray notesList = null;
        if (newData.getNotesList() != null) {
            notesList = DispoUtil.noteListToJsonObj(newData.getNotesList());
        }
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Update Dispo Set");
        if (name != null && !name.equals(origSetAs.getName())) {
            tx.setName((ArtifactId)dispoSet, name);
        }
        if (importPath != null && !importPath.equals(origSetAs.getImportPath())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.ImportPath, importPath);
        }
        if (notesList != null && !notesList.toString().equals(origSetAs.getNotesList().toString())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.DispoNotesJson, notesList.toString());
        }
        if (ciSet != null && !ciSet.equals(origSetAs.getCiSet())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.DispoCiSet, ciSet);
        }
        if (rerunList != null && !rerunList.equals(origSetAs.getRerunList())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.DispoRerunList, rerunList);
        }
        if (time != null && !time.equals(origSetAs.getTime())) {
            tx.setSoleAttributeValue((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.DispoTime, (Object)time);
        }
        tx.commit();
    }

    @Override
    public void createDispoItems(ArtifactReadable author, BranchId branch, DispoSet parentSet, List<DispoItem> data) {
        ArtifactReadable parentSetArt = this.findDispoArtifact(branch, (String)parentSet.getGuid(), DispoConstants.DispoSet);
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Create Dispoable Item");
        for (DispoItem item : data) {
            ArtifactToken createdItem = tx.createArtifact(DispoConstants.DispoItem, item.getName());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoDateCreated, (Object)item.getCreationDate());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoLastUpdated, (Object)item.getLastUpdate());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemStatus, (Object)item.getStatus());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemTotalPoints, (Object)item.getTotalPoints());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemNeedsRerun, (Object)item.getNeedsRerun());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemAborted, (Object)item.getAborted());
            String discrepanciesAsJsonString = DispoUtil.disrepanciesMapToJson(item.getDiscrepanciesList()).toString();
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoDiscrepanciesJson, discrepanciesAsJsonString);
            String annotationsAsJsonString = DispoUtil.annotationsListToJson(item.getAnnotationsList()).toString();
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoAnnotationsJson, annotationsAsJsonString);
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemVersion, item.getVersion());
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemAssignee, item.getAssignee());
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemMachine, item.getMachine());
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemCategory, item.getCategory());
            tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemElapsedTime, item.getElapsedTime());
            if (Strings.isValid((String)item.getFileNumber())) {
                tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemFileNumber, item.getFileNumber());
            }
            if (Strings.isValid((String)item.getMethodNumber())) {
                tx.setSoleAttributeFromString((ArtifactId)createdItem, (AttributeTypeId)DispoConstants.DispoItemMethodNumber, item.getMethodNumber());
            }
            tx.relate((ArtifactId)parentSetArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)createdItem);
        }
        tx.commit();
    }

    private void updateSingleItem(ArtifactReadable author, BranchId branch, ArtifactReadable currentItemArt, DispoItem newItemData, TransactionBuilder tx, boolean resetRerunFlag, DispoStorageMetadata metadata) {
        Date lastUpdate = newItemData.getLastUpdate();
        String name = newItemData.getName();
        JSONObject discrepanciesList = null;
        if (newItemData.getDiscrepanciesList() != null) {
            discrepanciesList = DispoUtil.disrepanciesMapToJson(newItemData.getDiscrepanciesList());
        }
        JSONArray annotationsList = null;
        if (newItemData.getAnnotationsList() != null) {
            annotationsList = DispoUtil.annotationsListToJson(newItemData.getAnnotationsList());
        }
        String status = newItemData.getStatus();
        String assignee = newItemData.getAssignee();
        String totalPoints = newItemData.getTotalPoints();
        String machine = newItemData.getMachine();
        String category = newItemData.getCategory();
        String elapsedTime = newItemData.getElapsedTime();
        Boolean aborted = newItemData.getAborted();
        String itemNotes = newItemData.getItemNotes();
        String fileNumber = newItemData.getFileNumber();
        String methodNumber = newItemData.getMethodNumber();
        String team = newItemData.getTeam();
        Boolean needsRerun = resetRerunFlag ? Boolean.valueOf(false) : newItemData.getNeedsRerun();
        DispoItemArtifact origItem = new DispoItemArtifact(currentItemArt);
        if (name != null && !name.equals(origItem.getName())) {
            tx.setName((ArtifactId)currentItemArt, name);
        }
        if (discrepanciesList != null && !discrepanciesList.equals(origItem.getDiscrepanciesList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoDiscrepanciesJson, discrepanciesList.toString());
        }
        if (annotationsList != null && !annotationsList.equals(origItem.getAnnotationsList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoAnnotationsJson, annotationsList.toString());
        }
        if (assignee != null && !assignee.equals(origItem.getAssignee())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemAssignee, assignee);
        }
        if (status != null && !status.equals(origItem.getStatus())) {
            metadata.addIdOfUpdatedItem((String)newItemData.getGuid());
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemStatus, status);
        }
        if (lastUpdate != null && !lastUpdate.equals(origItem.getLastUpdate())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoLastUpdated, (Object)lastUpdate);
        }
        if (needsRerun != null && !needsRerun.equals(origItem.getNeedsRerun())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemNeedsRerun, (Object)needsRerun);
        }
        if (totalPoints != null && !totalPoints.equals(origItem.getTotalPoints())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemTotalPoints, totalPoints);
        }
        if (machine != null && !machine.equals(origItem.getMachine())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemMachine, machine);
        }
        if (category != null && !category.equals(origItem.getCategory())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemCategory, category);
        }
        if (elapsedTime != null && !elapsedTime.equals(origItem.getElapsedTime())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemElapsedTime, elapsedTime);
        }
        if (aborted != null && !aborted.equals(origItem.getAborted())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemAborted, (Object)aborted);
        }
        if (itemNotes != null && !itemNotes.equals(origItem.getItemNotes())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemItemNotes, itemNotes);
        }
        if (fileNumber != null && !fileNumber.equals(origItem.getFileNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemFileNumber, fileNumber);
        }
        if (methodNumber != null && !methodNumber.equals(origItem.getMethodNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemMethodNumber, methodNumber);
        }
        if (team != null && !team.equals(origItem.getTeam())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeId)DispoConstants.DispoItemTeam, team);
        }
    }

    @Override
    public void updateDispoItem(ArtifactReadable author, BranchId branch, String dispoItemId, DispoItem data, DispoStorageMetadata metadata) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Update Dispo Item");
        ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, dispoItemId, DispoConstants.DispoItem);
        this.updateSingleItem(author, branch, dispoItemArt, data, tx, false, metadata);
        tx.commit();
    }

    @Override
    public void updateDispoItems(ArtifactReadable author, BranchId branch, Collection<DispoItem> data, boolean resetRerunFlag, String operation, DispoStorageMetadata metadata) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, operation);
        boolean isCommitNeeded = false;
        for (DispoItem newItem : data) {
            String itemId = (String)newItem.getGuid();
            if (!Strings.isValid((String)itemId)) continue;
            isCommitNeeded = true;
            ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, (String)newItem.getGuid(), DispoConstants.DispoItem);
            this.updateSingleItem(author, branch, dispoItemArt, newItem, tx, resetRerunFlag, metadata);
        }
        if (isCommitNeeded) {
            tx.commit();
        }
    }

    @Override
    public List<IOseeBranch> getDispoBranches() {
        ArrayList<IOseeBranch> dispoBranchesNormalized = new ArrayList<IOseeBranch>();
        BranchReadable dispoBranch = (BranchReadable)((BranchQuery)this.getQuery().branchQuery().andNameEquals("Dispo Parent")).getResults().getExactlyOne();
        ResultSet dispoBranches = ((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsOfType(new BranchType[]{BranchType.WORKING})).andIsChildOf((BranchId)dispoBranch)).getResults();
        for (BranchReadable branch : dispoBranches) {
            IOseeBranch newName = IOseeBranch.create((BranchId)branch, (String)branch.getName().replaceFirst("\\(DISPO\\)", ""));
            dispoBranchesNormalized.add(newName);
        }
        return dispoBranchesNormalized;
    }

    @Override
    public Collection<DispoItem> findDispoItemByAnnoationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        ArtifactReadable dispoSetArt = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        HashSet<DispoItem> toReturn = new HashSet<DispoItem>();
        ResultSet dispoArtifacts = ((QueryBuilder)((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispoItem})).andRelatedTo(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)dispoSetArt)).and((AttributeTypeId)DispoConstants.DispoAnnotationsJson, keyword, QueryOption.CONTAINS_MATCH_OPTIONS)).getResults();
        for (ArtifactReadable art : dispoArtifacts) {
            DispoItemArtifact dispoItem = new DispoItemArtifact(art);
            dispoItem.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItem);
        }
        return toReturn;
    }

    @Override
    public DispoItem findDispoItemById(BranchId branch, String itemId) {
        DispoItemArtifact toReturn = null;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, itemId, DispoConstants.DispoItem);
        if (dispoArtifact != null) {
            toReturn = new DispoItemArtifact(dispoArtifact);
        }
        return toReturn;
    }

    @Override
    public DispoConfig findDispoConfig(BranchId branch) {
        ArtifactReadable config = (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branch).andNameEquals("Program Config")).getResults().getOneOrNull();
        if (config == null) {
            return DispoUtil.getDefaultConfig();
        }
        return DispoUtil.configArtToConfigData(new DispoConfigArtifact(config));
    }

    @Override
    public String createDispoReport(BranchId branch, ArtifactReadable author, String contents, String operationTitle) {
        String toReturn = "";
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Update Report: " + operationTitle);
        ArtifactReadable reportArt = (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report")).getResults().getOneOrNull();
        if (reportArt == null) {
            TransactionBuilder txToCreate = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Add Operation Report Art");
            txToCreate.createArtifact(CoreArtifactTypes.GeneralData, "Dispo_Report");
            txToCreate.commit();
            reportArt = (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report")).getResults().getExactlyOne();
        }
        tx.setSoleAttributeFromString((ArtifactId)reportArt, (AttributeTypeId)CoreAttributeTypes.GeneralStringData, contents);
        TransactionReadable commit = tx.commit();
        if (commit != null) {
            ArtifactReadable newRerpotArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch(branch).fromTransaction((TransactionId)commit)).andId((ArtifactId)reportArt)).getResults().getExactlyOne();
            AttributeReadable contentsAsAttribute = (AttributeReadable)newRerpotArt.getAttributes((AttributeTypeId)CoreAttributeTypes.GeneralStringData).getExactlyOne();
            toReturn = String.format("/orcs/branch/%s/artifact/%s/attribute/%s/version/%s", branch, newRerpotArt.getGuid(), contentsAsAttribute.getLocalId(), commit.getId());
        }
        return toReturn;
    }

    @Override
    public Map<String, ArtifactReadable> getCoverageUnits(BranchId branchId, Long artifactUuid) {
        ArtifactReadable coveragePackage = (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branchId).andUuid(artifactUuid.longValue())).getResults().getOneOrNull();
        List descendants = coveragePackage.getDescendants();
        return this.getChildrenRecurse(descendants);
    }

    private Map<String, ArtifactReadable> getChildrenRecurse(List<ArtifactReadable> descendants) {
        HashMap<String, ArtifactReadable> toReturn = new HashMap<String, ArtifactReadable>();
        for (ArtifactReadable descendant : descendants) {
            if (descendant.getAttributeValues((AttributeTypeId)CoverageUtil.Item).isEmpty()) continue;
            ArtifactReadable parent = descendant.getParent();
            String fullName = String.format("%s.%s", parent.getName(), descendant.getName());
            toReturn.put(fullName, descendant);
        }
        return toReturn;
    }

    @Override
    public void updateOperationSummary(ArtifactReadable author, BranchId branch, String setId, OperationReport summary) {
        OperationReport newReport = DispoUtil.cleanOperationReport(summary);
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId, DispoConstants.DispoSet);
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, (ArtifactId)author, "Update Dispo Operation Report");
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.ImportState, newReport.getStatus().getName());
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeId)DispoConstants.OperationSummary, DispoUtil.operationReportToString(newReport));
        tx.commit();
    }

    @Override
    public Long getDispoItemParentSet(BranchId branch, String itemId) {
        ArtifactReadable artifact = this.findDispoArtifact(branch, itemId, DispoConstants.DispoItem);
        return artifact.getParent().getUuid();
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        HashMap<ArtifactReadable, BranchId> set = new HashMap<ArtifactReadable, BranchId>();
        BranchId branch = BranchId.valueOf((String)setData.getBranchId());
        List<ArtifactReadable> arts = this.findDispoSet(branch, ArtifactId.valueOf((String)setData.getDispoSetId()));
        for (ArtifactReadable art : arts) {
            set.put(art, branch);
        }
        return set;
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        ArtifactReadable DispoSet2 = (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(branch).andId(ArtifactId.valueOf((String)setId))).getResults().getOneOrNull();
        for (ArtifactReadable child : DispoSet2.getChildren()) {
            if (!child.getName().equals(item)) continue;
            return child.getIdString();
        }
        return "";
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        ArrayList<CiSetData> setData = new ArrayList<CiSetData>();
        List<BranchReadable> dispoBranches = this.findDispoBranches();
        for (BranchReadable branch : dispoBranches) {
            for (ArtifactReadable dispoSet : this.findAllCiSets((BranchId)branch)) {
                String ciSet = (String)dispoSet.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoCiSet, (Object)"");
                if (ciSet.isEmpty()) continue;
                CiSetData set = new CiSetData();
                set.setBranchId(branch.getIdString());
                set.setDispoSetId(dispoSet.getIdString());
                set.setCiSetName(ciSet);
                setData.add(set);
            }
        }
        return setData;
    }

    private List<ArtifactReadable> findDispoSet(BranchId branch, ArtifactId setId) {
        return ((QueryBuilder)this.getQuery().fromBranch(branch).andId(setId)).getResults().getList();
    }

    private List<BranchReadable> findDispoBranches() {
        BranchReadable dispoParent = (BranchReadable)((BranchQuery)this.getQuery().branchQuery().andNameEquals("Dispo Parent")).getResults().getOneOrNull();
        return ((BranchQuery)((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsChildOf((BranchId)dispoParent)).excludeArchived()).excludeDeleted()).getResults().getList();
    }

    private List<ArtifactReadable> findAllCiSets(BranchId branch) {
        return ((QueryBuilder)((QueryBuilder)this.getQuery().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{DispoConstants.DispoSet})).andExists(new AttributeTypeId[]{DispoConstants.DispoCiSet})).getResults().getList();
    }
}

