/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DispoSetArtifact
extends BaseIdentity<String>
implements DispoSet {
    private final ArtifactReadable artifact;

    public DispoSetArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getImportPath() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.ImportPath);
    }

    public List<Note> getNotesList() {
        ArrayList<Note> toReturn = new ArrayList<Note>();
        String notesJson = this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoNotesJson, "[]");
        try {
            JSONArray jArray = new JSONArray(notesJson);
            int i = 0;
            while (i < jArray.length()) {
                toReturn.add(DispoUtil.jsonObjToNote(jArray.getJSONObject(i)));
                ++i;
            }
            return toReturn;
        }
        catch (JSONException ex) {
            throw new OseeCoreException("Could not parse Notes Json", (Throwable)ex);
        }
    }

    public OperationReport getOperationSummary() {
        String operationSummaryJson = this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.OperationSummary, "{}");
        try {
            JSONObject jsonObject = new JSONObject(operationSummaryJson);
            return DispoUtil.jsonObjToOperationSummary(jsonObject);
        }
        catch (JSONException ex) {
            throw new OseeCoreException("Could not parse Operation Sumary Json", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getImportState() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.ImportState, "None");
    }

    public String getDispoType() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoType, "");
    }

    public String getCiSet() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoCiSet, "");
    }

    public String getRerunList() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoRerunList, "");
    }

    public Date getTime() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoTime, null);
    }
}

