/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Map;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class DispoResolutionValidator {
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting ResolutionValidator...", new Object[0]);
    }

    public void stop() {
        this.logger.trace("Stopping ResolutionValidator...", new Object[0]);
    }

    public void validate(DispoAnnotationData annotation) {
        annotation.setIsResolutionValid(this.isValid(annotation));
        annotation.setIsAnalyze(this.isAnalyze(annotation));
    }

    private boolean isAnalyze(DispoAnnotationData annotation) {
        String type = annotation.getResolutionType();
        boolean toReturn = false;
        if (type.equals("Modify_Code") || type.equals("Modify_Test") || type.equals("Modify_Reqt")) {
            toReturn = true;
        }
        return toReturn;
    }

    private boolean isValid(DispoAnnotationData annotation) {
        String pcr = annotation.getResolution().toUpperCase().trim();
        boolean isValid = false;
        if (Strings.isValid((String)pcr)) {
            isValid = true;
        }
        return isValid;
    }
}

