/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DispoItemArtifact
extends BaseIdentity<String>
implements DispoItem {
    private final ArtifactReadable artifact;
    private boolean isIncludeDetails;

    public DispoItemArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public void setIsIncludeDetails(boolean isIncludeDetails) {
        this.isIncludeDetails = isIncludeDetails;
    }

    public boolean getIsIncludeDetails() {
        return this.isIncludeDetails;
    }

    public Map<String, Discrepancy> getDiscrepanciesList() {
        HashMap<String, Discrepancy> toReturn = new HashMap<String, Discrepancy>();
        String discrepanciesJson = this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoDiscrepanciesJson, "{}");
        try {
            JSONObject jObject = DispoUtil.asJSONObject(discrepanciesJson);
            Iterator keys = jObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Discrepancy discrepancy = DispoUtil.jsonObjToDiscrepancy(jObject.getJSONObject(key));
                toReturn.put(key, discrepancy);
            }
            return toReturn;
        }
        catch (JSONException ex) {
            throw new OseeCoreException("Could not parse Discrepancies Json", (Throwable)ex);
        }
    }

    public List<DispoAnnotationData> getAnnotationsList() {
        ArrayList<DispoAnnotationData> toReturn = new ArrayList<DispoAnnotationData>();
        String annotationsList = this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoAnnotationsJson, "[]");
        try {
            JSONArray jArray = DispoUtil.asJSONArray(annotationsList);
            int i = 0;
            while (i < jArray.length()) {
                DispoAnnotationData annotation = DispoUtil.jsonObjToDispoAnnotationData(jArray.getJSONObject(i));
                toReturn.add(annotation);
                ++i;
            }
            return toReturn;
        }
        catch (JSONException ex) {
            throw new OseeCoreException("Could not parse Annotations Json", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getAssignee() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemAssignee, "");
    }

    public Date getCreationDate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoDateCreated);
    }

    public Date getLastUpdate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoLastUpdated);
    }

    public String getStatus() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemStatus);
    }

    public String getVersion() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemVersion);
    }

    public Boolean getNeedsRerun() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoItemNeedsRerun, (Object)false);
    }

    public String getTotalPoints() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemTotalPoints, "0");
    }

    public String getMachine() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemMachine, "n/a");
    }

    public String getCategory() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemCategory, "");
    }

    public String getElapsedTime() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemElapsedTime, "0.0");
    }

    public Boolean getAborted() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoItemAborted, (Object)false);
    }

    public String getItemNotes() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemItemNotes, "");
    }

    public String getMethodNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemMethodNumber, "");
    }

    public String getFileNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemFileNumber, "");
    }

    public Boolean getNeedsReview() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)DispoConstants.DispoItemNeedsReview, (Object)false);
    }

    public String getTeam() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)DispoConstants.DispoItemTeam, "");
    }
}

