/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.ResolutionMethod;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DispoConfigArtifact
implements DispoConfig {
    private final ArtifactReadable artifact;

    public DispoConfigArtifact(ArtifactReadable artifact) {
        this.artifact = artifact;
    }

    public List<ResolutionMethod> getValidResolutions() {
        ArrayList<ResolutionMethod> toReturn = new ArrayList<ResolutionMethod>();
        List attributes = this.artifact.getAttributeValues((AttributeTypeId)CoreAttributeTypes.GeneralStringData);
        String resolutionsJson = "[]";
        for (String attribute : attributes) {
            if (!attribute.startsWith("RESOLUTION_METHODS")) continue;
            resolutionsJson = attribute.replaceFirst("RESOLUTION_METHODS=", "");
            break;
        }
        try {
            JSONArray jArray = DispoUtil.asJSONArray(resolutionsJson);
            int i = 0;
            while (i < jArray.length()) {
                JSONObject resolutionMethodJObject = jArray.getJSONObject(i);
                ResolutionMethod method = DispoUtil.jsonObjToResolutionMethod(resolutionMethodJObject);
                toReturn.add(method);
                ++i;
            }
            return toReturn;
        }
        catch (JSONException ex) {
            throw new OseeCoreException("Invalid Resolutions JSON in Dispo Config", (Throwable)ex);
        }
    }
}

