/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.disposition.model.CiItemData;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.CopySetParams;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetData;
import org.eclipse.osee.disposition.model.DispoSetDescriptorData;
import org.eclipse.osee.disposition.model.DispoStorageMetadata;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.external.DispoUpdateBroadcaster;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.DispoQuery;
import org.eclipse.osee.disposition.rest.internal.DispoResolutionValidator;
import org.eclipse.osee.disposition.rest.internal.DispoWriter;
import org.eclipse.osee.disposition.rest.internal.StorageProvider;
import org.eclipse.osee.disposition.rest.internal.importer.DispoImporterFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageAdapter;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class DispoApiImpl
implements DispoApi {
    private ExecutorAdmin executor;
    private Log logger;
    private StorageProvider storageProvider;
    private DispoDataFactory dataFactory;
    private DispoConnector dispoConnector;
    private DispoResolutionValidator resolutionValidator;
    private DispoImporterFactory importerFactory;
    private DispoUpdateBroadcaster updateBroadcaster;
    private volatile DispoApiConfiguration config;
    private final Date newDate = new Date();

    @Override
    public DispoApiConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(DispoApiConfiguration config) {
        this.config = config;
    }

    public void setExecutor(ExecutorAdmin executor) {
        this.executor = executor;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setDataFactory(DispoDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public void setDispoConnector(DispoConnector dispoConnector) {
        this.dispoConnector = dispoConnector;
    }

    public void setStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public void setResolutionValidator(DispoResolutionValidator resolutionValidator) {
        this.resolutionValidator = resolutionValidator;
    }

    public void setDispoUpdateBroadcaster(DispoUpdateBroadcaster updateBroadcater) {
        this.updateBroadcaster = updateBroadcater;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting DispoApiImpl...", new Object[0]);
        this.update(props);
        this.importerFactory = new DispoImporterFactory(this.dataFactory, this.executor, this.config, this.logger);
    }

    public void update(Map<String, Object> props) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.setConfig(DispoApiConfiguration.newConfig(props));
    }

    public void stop() {
        this.logger.trace("Stopping DispoApiImpl...", new Object[0]);
    }

    private DispoQuery getQuery() {
        return this.storageProvider.get();
    }

    private DispoWriter getWriter() {
        return this.storageProvider.get();
    }

    @Override
    public Long createDispoProgram(String name) {
        ArtifactReadable author = this.getQuery().findUser();
        return this.getWriter().createDispoProgram(author, name);
    }

    @Override
    public Long createDispoSet(BranchId branch, DispoSetDescriptorData descriptor) {
        DispoSetData newSet = this.dataFactory.creteSetDataFromDescriptor(descriptor);
        ArtifactReadable author = this.getQuery().findUser();
        return this.getWriter().createDispoSet(author, branch, (DispoSet)newSet);
    }

    private void createDispoItems(BranchId branch, String setId, List<DispoItem> dispoItems) {
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, setId);
        if (parentSet != null) {
            ArtifactReadable author = this.getQuery().findUser();
            this.getWriter().createDispoItems(author, branch, parentSet, dispoItems);
        }
    }

    @Override
    public String createDispoAnnotation(BranchId branch, String itemId, DispoAnnotationData annotationToCreate, String userName, boolean isCi) {
        String idOfNewAnnotation = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            this.dataFactory.initAnnotation(annotationToCreate);
            idOfNewAnnotation = this.dataFactory.getNewId();
            annotationToCreate.setId(idOfNewAnnotation);
            int indexOfAnnotation = annotationsList.size();
            annotationToCreate.setIndex(indexOfAnnotation);
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            this.dispoConnector.connectAnnotation(annotationToCreate, discrepanciesList);
            annotationsList.add(indexOfAnnotation, annotationToCreate);
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(annotationsList, discrepanciesList);
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), updatedItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(dispoItem), this.getDispoItemParentSet(branch, itemId));
            }
        }
        return idOfNewAnnotation;
    }

    @Override
    public void editDispoSet(BranchId branch, String setId, DispoSetData newSet) throws OseeCoreException {
        DispoSet dispSetToEdit = this.getQuery().findDispoSetsById(branch, setId);
        if (dispSetToEdit != null) {
            if (newSet.getOperation() != null) {
                this.runOperation(branch, dispSetToEdit, newSet);
            }
            ArtifactReadable author = this.getQuery().findUser();
            this.getWriter().updateDispoSet(author, branch, (String)dispSetToEdit.getGuid(), (DispoSet)newSet);
        }
    }

    @Override
    public boolean deleteDispoSet(BranchId branch, String setId) {
        ArtifactReadable author = this.getQuery().findUser();
        this.updateBroadcaster.broadcastDeleteSet(this.getDispoSetById(branch, setId));
        return this.getWriter().deleteDispoSet(author, branch, setId);
    }

    @Override
    public boolean editDispoItem(BranchId branch, String itemId, DispoItemData newDispoItem) {
        boolean wasUpdated = false;
        DispoItem dispoItemToEdit = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItemToEdit != null && newDispoItem.getAnnotationsList() == null && newDispoItem.getDiscrepanciesList() == null) {
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItemToEdit));
                newDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            this.getWriter().updateDispoItem(author, branch, (String)dispoItemToEdit.getGuid(), (DispoItem)newDispoItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(newDispoItem), this.getDispoItemParentSet(branch, itemId));
            }
            wasUpdated = true;
        }
        return wasUpdated;
    }

    private String getFullFilePathFromDispoItemId(BranchId branch, String itemId, DispoItem dispoItemToEdit) {
        DispoSet dispoSet;
        Conditions.notNull((Object[])new Object[]{dispoItemToEdit});
        Conditions.notNull((Object[])new Object[]{branch});
        Conditions.notNull((Object[])new Object[]{itemId});
        Long set = this.getQuery().getDispoItemParentSet(branch, itemId);
        if (set != null && (dispoSet = this.getQuery().findDispoSetsById(branch, String.valueOf(set))) != null) {
            String importPath = dispoSet.getImportPath();
            String name = dispoItemToEdit.getName().replaceAll(this.config.getFileExtRegex(), ".LIS");
            return String.valueOf(importPath) + File.separator + "vcast" + File.separator + name;
        }
        return "";
    }

    @Override
    public boolean massEditTeam(BranchId branch, String setId, List<String> itemNames, String team, String operation) {
        boolean wasUpdated = false;
        HashSet<DispoItem> dispoItems = new HashSet<DispoItem>();
        List<DispoItem> itemsFromSet = this.getDispoItems(branch, setId);
        HashMap<String, String> nameToId = new HashMap<String, String>();
        OperationReport report = new OperationReport();
        for (DispoItem item : itemsFromSet) {
            nameToId.put(item.getName(), (String)item.getGuid());
        }
        HashSet<String> itemsUpdated = new HashSet<String>();
        for (String name : itemNames) {
            String matchingItemId = (String)nameToId.get(name = name.trim());
            if (matchingItemId == null) {
                report.addEntry(name, "No existing item with this name for the selected set", DispoSummarySeverity.WARNING);
                continue;
            }
            itemsUpdated.add(name);
            DispoItemData newItem = new DispoItemData();
            newItem.setGuid(matchingItemId);
            newItem.setTeam(team);
            dispoItems.add((DispoItem)newItem);
        }
        if (!itemsUpdated.isEmpty()) {
            report.addEntry(team, String.format("Team Applied to %s of %s items", itemsUpdated.size(), itemNames.size()), DispoSummarySeverity.UPDATE);
            if (itemsUpdated.size() != itemNames.size()) {
                HashSet<String> uniqueNames = new HashSet<String>(itemNames);
                itemNames.removeAll(uniqueNames);
                if (!itemNames.isEmpty()) {
                    String duplicatesAsString = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)", ", itemNames);
                    report.addEntry(team, String.format("There were %s duplciates: %s", itemNames.size(), duplicatesAsString), DispoSummarySeverity.WARNING);
                }
            }
            this.editDispoItems(branch, setId, dispoItems, false, operation);
        } else {
            report.addEntry("Womp womp womp", "No items were updated. Please check your 'Items' list and make sure it's a comma seperated list of item names", DispoSummarySeverity.ERROR);
        }
        ArtifactReadable author = this.getQuery().findUser();
        this.getWriter().updateOperationSummary(author, branch, setId, report);
        return wasUpdated;
    }

    private boolean editDispoItems(BranchId branch, String setId, Collection<DispoItem> dispoItems, boolean resetRerunFlag, String operation) {
        boolean wasUpdated = false;
        ArtifactReadable author = this.getQuery().findUser();
        DispoStorageMetadata metadata = new DispoStorageMetadata();
        this.getWriter().updateDispoItems(author, branch, dispoItems, resetRerunFlag, operation, metadata);
        if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
            this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), dispoItems, this.getDispoSetById(branch, setId));
        }
        wasUpdated = true;
        return wasUpdated;
    }

    @Override
    public boolean deleteDispoItem(BranchId branch, String itemId) {
        ArtifactReadable author = this.getQuery().findUser();
        return this.getWriter().deleteDispoItem(author, branch, itemId);
    }

    @Override
    public boolean editDispoAnnotation(BranchId branch, String itemId, String annotationId, DispoAnnotationData newAnnotation, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            boolean isResolutionChange;
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData origAnnotation = DispoUtil.getById(annotationsList, annotationId);
            int indexOfAnnotation = origAnnotation.getIndex();
            boolean needToReconnect = false;
            String newLocationRefs = newAnnotation.getLocationRefs();
            String newResolution = newAnnotation.getResolution();
            String newResolutionType = newAnnotation.getResolutionType();
            boolean isTypeChange = !origAnnotation.getResolutionType().equals(newResolutionType);
            boolean bl = isResolutionChange = !origAnnotation.getResolution().equals(newResolution);
            if (isTypeChange || isResolutionChange) {
                needToReconnect = true;
                this.resolutionValidator.validate(newAnnotation);
            }
            if (!origAnnotation.getLocationRefs().equals(newLocationRefs)) {
                needToReconnect = true;
            }
            if (needToReconnect) {
                newAnnotation.disconnect();
                this.dispoConnector.connectAnnotation(newAnnotation, discrepanciesList);
            }
            annotationsList.set(indexOfAnnotation, newAnnotation);
            ArtifactReadable author = this.getQuery().findUser();
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setAnnotationsList(annotationsList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(modifiedDispoItem), this.getDispoItemParentSet(branch, itemId));
            }
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteDispoAnnotation(BranchId branch, String itemId, String annotationId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData annotationToRemove = DispoUtil.getById(annotationsList, annotationId);
            annotationToRemove.disconnect();
            List<DispoAnnotationData> newAnnotationsList = this.removeAnnotationFromList(annotationsList, annotationToRemove.getIndex());
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(newAnnotationsList, discrepanciesList);
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), updatedItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(updatedItem), this.getDispoItemParentSet(branch, itemId));
            }
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteAllDispoAnnotation(BranchId branch, String itemId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                wasUpdated = this.deleteDispoAnnotation(branch, itemId, annotation.getId(), userName, isCi);
            }
        }
        return wasUpdated;
    }

    @Override
    public List<IOseeBranch> getDispoPrograms() {
        return this.getQuery().getDispoBranches();
    }

    @Override
    public List<DispoSet> getDispoSets(BranchId branch, String type) throws OseeCoreException {
        return this.getQuery().findDispoSets(branch, type);
    }

    @Override
    public DispoSet getDispoSetById(BranchId branch, String setId) throws OseeCoreException {
        return this.getQuery().findDispoSetsById(branch, setId);
    }

    @Override
    public List<DispoItem> getDispoItems(BranchId branch, String setArtId, boolean isDetailed) {
        return this.getQuery().findDipoItems(branch, setArtId, isDetailed);
    }

    private List<DispoItem> getDispoItems(BranchId branch, String setArtId) {
        return this.getDispoItems(branch, setArtId, true);
    }

    @Override
    public DispoItem getDispoItemById(BranchId branch, String itemId) {
        return this.getQuery().findDispoItemById(branch, itemId);
    }

    @Override
    public Collection<DispoItem> getDispoItemByAnnotationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        return this.getQuery().findDispoItemByAnnoationText(branch, setId, keyword, isDetailed);
    }

    @Override
    public List<DispoAnnotationData> getDispoAnnotations(BranchId branch, String itemId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        return dispoItem.getAnnotationsList();
    }

    @Override
    public DispoAnnotationData getDispoAnnotationById(BranchId branch, String itemId, String annotationId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        List annotationsList = dispoItem.getAnnotationsList();
        return DispoUtil.getById(annotationsList, annotationId);
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        return this.getQuery().isUniqueProgramName(name);
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        return this.getQuery().isUniqueItemName(branch, setId, name);
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        return this.getQuery().isUniqueSetName(branch, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOperation(BranchId branch, DispoSet setToEdit, DispoSetData newSet) {
        ArtifactReadable author;
        String operation;
        OperationReport report;
        block9: {
            report = new OperationReport();
            operation = newSet.getOperation();
            author = this.getQuery().findUser();
            if (operation.equals("Import")) {
                try {
                    HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, setToEdit);
                    DispoImporterApi importer = setToEdit.getDispoType().equalsIgnoreCase("codeCoverage") ? this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.LIS, this.dispoConnector) : this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.TMO, this.dispoConnector);
                    List<DispoItem> itemsFromParse = importer.importDirectory(nameToItemMap, new File(setToEdit.getImportPath()), report);
                    ArrayList<DispoItem> itemsToCreate = new ArrayList<DispoItem>();
                    ArrayList<DispoItem> itemsToEdit = new ArrayList<DispoItem>();
                    Iterator<DispoItem> iterator = itemsFromParse.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (report.getStatus().isFailed()) break block9;
                            if (itemsToCreate.size() > 0) {
                                this.createDispoItems(branch, (String)setToEdit.getGuid(), itemsToCreate);
                            }
                            if (itemsToEdit.size() > 0) {
                                this.editDispoItems(branch, (String)setToEdit.getGuid(), itemsToEdit, true, "Import");
                            }
                            break block9;
                        }
                        DispoItem item = iterator.next();
                        if (item.getGuid() == null) {
                            itemsToCreate.add(item);
                            report.addEntry(item.getName(), "", DispoSummarySeverity.NEW);
                            continue;
                        }
                        itemsToEdit.add(item);
                    }
                }
                catch (Exception ex) {
                    throw new OseeCoreException((Throwable)ex);
                }
            }
            if (operation.equals("MassSendDispoItemStatus")) {
                this.MassSendDispoItemStatus(branch, setToEdit);
            }
        }
        List notesList = setToEdit.getNotesList();
        Note genOpNotes = this.generateOperationNotes(operation);
        notesList.add(genOpNotes);
        newSet.setNotesList(notesList);
        this.newDate.setTime(System.currentTimeMillis());
        newSet.setTime(this.newDate);
        this.getWriter().updateOperationSummary(author, branch, (String)setToEdit.getGuid(), report);
    }

    private void MassSendDispoItemStatus(BranchId branch, DispoSet set) {
        try {
            HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, set);
            ArrayList<String> ids = new ArrayList<String>();
            for (DispoItem item : nameToItemMap.values()) {
                ids.add((String)item.getGuid());
            }
            this.updateBroadcaster.broadcastDeleteSet(set);
            this.updateBroadcaster.broadcastUpdateItems(ids, nameToItemMap.values(), set);
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private HashMap<String, DispoItem> getItemsMap(BranchId branch, DispoSet set) {
        HashMap<String, DispoItem> toReturn = new HashMap<String, DispoItem>();
        List<DispoItem> dispoItems = this.getDispoItems(branch, (String)set.getGuid());
        for (DispoItem item : dispoItems) {
            toReturn.put(item.getName(), item);
        }
        return toReturn;
    }

    private Note generateOperationNotes(String operation) {
        Note operationNote = new Note();
        this.newDate.setTime(System.currentTimeMillis());
        operationNote.setDateString(this.newDate.toString());
        operationNote.setType("SYSTEM");
        operationNote.setContent(operation);
        return operationNote;
    }

    private List<DispoAnnotationData> removeAnnotationFromList(List<DispoAnnotationData> oldList, int indexRemoved) {
        ArrayList<DispoAnnotationData> newList = new ArrayList<DispoAnnotationData>();
        oldList.remove(indexRemoved);
        int newIndex = 0;
        for (DispoAnnotationData annotation : oldList) {
            annotation.setIndex(newIndex);
            newList.add(newIndex, annotation);
            ++newIndex;
        }
        return newList;
    }

    @Override
    public void copyDispoSetCoverage(BranchId sourceBranch, Long sourceCoverageUuid, BranchId destBranch, String destSetId, CopySetParams params) {
        Map<String, ArtifactReadable> coverageUnits = this.getQuery().getCoverageUnits(sourceBranch, sourceCoverageUuid);
        List<DispoItem> destItems = this.getDispoItems(destBranch, destSetId);
        OperationReport report = new OperationReport();
        CoverageAdapter coverageAdapter = new CoverageAdapter(this.dispoConnector);
        List<DispoItem> copyData = coverageAdapter.copyData(coverageUnits, destItems, report);
        String operation = String.format("Copy From Legacy Coverage - Branch [%s] and Source Set [%s]", sourceBranch, sourceCoverageUuid);
        if (!copyData.isEmpty()) {
            this.editDispoItems(destBranch, destSetId, copyData, false, operation);
            this.storageProvider.get().updateOperationSummary(this.getQuery().findUser(), destBranch, destSetId, report);
        }
    }

    @Override
    public void copyDispoSet(BranchId branch, String destSetId, BranchId sourceBranch, String sourceSetId, CopySetParams params) {
        List<DispoItem> sourceItems = this.getDispoItems(sourceBranch, sourceSetId);
        HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
        for (DispoItem itemArt : this.getDispoItems(branch, destSetId)) {
            DispoItemData itemData = DispoUtil.itemArtToItemData(itemArt, true, true);
            String name = itemData.getName();
            Set itemsWithSameName = (Set)namesToDestItems.get(name);
            if (itemsWithSameName == null) {
                HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                set.add(itemData);
                namesToDestItems.put(name, set);
                continue;
            }
            itemsWithSameName.add(itemData);
            namesToDestItems.put(name, itemsWithSameName);
        }
        HashMap<String, String> reruns = new HashMap<String, String>();
        HashMap<String, DispoItem> namesToToEditItems = new HashMap<String, DispoItem>();
        OperationReport report = new OperationReport();
        DispoSetCopier copier = new DispoSetCopier(this.dispoConnector);
        if (!params.getAnnotationParam().isNone()) {
            List<DispoItem> copyResults = copier.copyAllDispositions(namesToDestItems, sourceItems, true, reruns, report);
            for (DispoItem item : copyResults) {
                namesToToEditItems.put(item.getName(), item);
            }
        }
        copier.copyCategories(namesToDestItems, sourceItems, namesToToEditItems, params.getCategoryParam());
        copier.copyAssignee(namesToDestItems, sourceItems, namesToToEditItems, params.getAssigneeParam());
        copier.copyNotes(namesToDestItems, sourceItems, namesToToEditItems, params.getNoteParam());
        String operation = String.format("Copy Set from Program [%s] and Set [%s]", sourceBranch, sourceSetId);
        if (!namesToToEditItems.isEmpty() && !report.getStatus().isFailed()) {
            this.editDispoItems(branch, destSetId, namesToToEditItems.values(), false, operation);
            this.storageProvider.get().updateOperationSummary(this.getQuery().findUser(), branch, destSetId, report);
        }
        this.storeRerunData(branch, destSetId, reruns);
    }

    private void storeRerunData(BranchId branch, String destSetId, HashMap<String, String> reruns) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : reruns.entrySet()) {
            sb = sb.append("\t\t<ScriptEntry>\n");
            sb = sb.append(String.format("\t\t\t<Name>%s</Name>\n", entry.getKey()));
            sb = sb.append(String.format("\t\t\t<Path>%s</Path>\n", entry.getValue()));
            sb = sb.append("\t\t\t<IsRunnable>true</IsRunnable>\n");
            sb = sb.append("\t\t</ScriptEntry>\n");
        }
        DispoSetData dispoSetData = new DispoSetData();
        this.newDate.setTime(System.currentTimeMillis());
        dispoSetData.setTime(this.newDate);
        dispoSetData.setRerunList("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TestManagerConfig>\n\t<ScriptPageConfig>\n\t\t<ServicesSettings/>\n" + sb.toString() + "\t</ScriptPageConfig>\n</TestManagerConfig>");
        ArtifactReadable author = this.getQuery().findUser();
        this.storageProvider.get().updateDispoSet(author, branch, destSetId, (DispoSet)dispoSetData);
    }

    @Override
    public DispoConfig getDispoConfig(BranchId branch) {
        return this.getQuery().findDispoConfig(branch);
    }

    @Override
    public DispoSet getDispoItemParentSet(BranchId branch, String itemId) {
        Long id = this.getQuery().getDispoItemParentSet(branch, itemId);
        return this.getDispoSetById(branch, String.valueOf(id));
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        return this.getQuery().getCiSet(setData);
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        return this.getQuery().getDispoItemId(branch, setId, item);
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        return this.getQuery().getAllCiSets();
    }

    @Override
    public String createDispoDiscrepancy(BranchId branch, String itemId, Discrepancy discrepancy, String userName) {
        String idOfNewDiscrepancy = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            idOfNewDiscrepancy = this.dataFactory.getNewId();
            discrepancy.setId(idOfNewDiscrepancy);
            if (discrepancy.getLocation() == null) {
                discrepancy.setLocation("");
            }
            if (discrepancy.getText() == null) {
                discrepancy.setText("");
            }
            discrepancyList.put(idOfNewDiscrepancy, discrepancy);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepancyList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)newItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(dispoItem), this.getDispoItemParentSet(branch, itemId));
            }
        }
        return idOfNewDiscrepancy;
    }

    @Override
    public void createDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            ArrayList<DispoItem> dispoItems = new ArrayList<DispoItem>();
            for (Discrepancy discrepancy : discrepancies) {
                String idOfNewDiscrepancy = "";
                idOfNewDiscrepancy = this.dataFactory.getNewId();
                discrepancy.setId(idOfNewDiscrepancy);
                if (discrepancy.getLocation() == null) {
                    discrepancy.setLocation("");
                }
                if (discrepancy.getText() == null) {
                    discrepancy.setText("");
                }
                discrepancyList.put(idOfNewDiscrepancy, discrepancy);
                DispoItemData newItem = new DispoItemData();
                newItem.setDiscrepanciesList(discrepancyList);
                newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
                dispoItems.add((DispoItem)newItem);
            }
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            String operation = String.format("Create Dispo Discrepancies in Program [%s], Item [%s]", branch, itemId);
            this.getWriter().updateDispoItems(author, branch, dispoItems, false, operation, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(dispoItem), this.getDispoItemParentSet(branch, itemId));
            }
        }
    }

    @Override
    public boolean editDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, Discrepancy newDiscrepancy, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.put(discrepancyId, newDiscrepancy);
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            ArtifactReadable author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(modifiedDispoItem), this.getDispoItemParentSet(branch, itemId));
            }
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public void editDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            for (Discrepancy discrepancy : discrepancies) {
                discrepanciesList.put(discrepancy.getId(), discrepancy);
            }
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            ArtifactReadable author = this.getQuery().findUser();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(modifiedDispoItem), this.getDispoItemParentSet(branch, itemId));
            }
        }
    }

    @Override
    public boolean deleteDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.remove(discrepancyId);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepanciesList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            ArtifactReadable author = this.getQuery().findUser();
            DispoStorageMetadata metadata = new DispoStorageMetadata();
            this.getWriter().updateDispoItem(author, branch, (String)dispoItem.getGuid(), (DispoItem)newItem, metadata);
            if (!metadata.getIdsOfUpdatedItems().isEmpty()) {
                this.updateBroadcaster.broadcastUpdateItems(metadata.getIdsOfUpdatedItems(), Collections.singleton(newItem), this.getDispoItemParentSet(branch, itemId));
            }
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public String createDispoItem(BranchId branch, CiItemData data, String userName) {
        DispoItemData dispoItemData = new DispoItemData();
        dispoItemData.setName(data.getScriptName());
        dispoItemData.setAssignee(this.getQuery().findUnassignedUser().getName());
        dispoItemData.setGuid(this.dataFactory.getNewId());
        dispoItemData.setCreationDate(new Date());
        dispoItemData.setDiscrepanciesAsRanges(data.getTestPoints().getFail());
        dispoItemData.setDiscrepanciesList(new HashMap());
        dispoItemData.setAnnotationsList(data.getAnnotations());
        ArrayList<DispoItem> newItem = new ArrayList<DispoItem>();
        newItem.add((DispoItem)dispoItemData);
        ArtifactReadable author = this.getQuery().findUser();
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, data.getSetData().getDispoSetId());
        if (parentSet != null) {
            this.getWriter().createDispoItems(author, branch, parentSet, newItem);
        }
        return dispoItemData.getGuid();
    }
}

