/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest;

import java.util.Map;
import org.eclipse.osee.disposition.rest.DispoConstants;

public class DispoApiConfiguration {
    private String fileExtRegex;
    private String resultsFileExtRegex;

    private DispoApiConfiguration() {
    }

    public String getFileExtRegex() {
        return this.fileExtRegex;
    }

    public void setFileExtRegex(String fileExtRegex) {
        this.fileExtRegex = fileExtRegex;
    }

    public String getResultsFileExtRegex() {
        return this.resultsFileExtRegex;
    }

    public void setResultsFileExtRegex(String resultsFileExtRegex) {
        this.resultsFileExtRegex = resultsFileExtRegex;
    }

    public DispoApiConfiguration copy() {
        DispoApiConfiguration data = new DispoApiConfiguration();
        data.fileExtRegex = this.fileExtRegex;
        data.resultsFileExtRegex = this.resultsFileExtRegex;
        return data;
    }

    public static DispoApiConfigurationBuilder newBuilder() {
        return new DispoApiConfigurationBuilder();
    }

    public static DispoApiConfigurationBuilder fromProperties(Map<String, Object> props) {
        return DispoApiConfiguration.newBuilder().properties(props);
    }

    public static DispoApiConfiguration newConfig(Map<String, Object> props) {
        return DispoApiConfiguration.fromProperties(props).build();
    }

    /* synthetic */ DispoApiConfiguration(DispoApiConfiguration dispoApiConfiguration) {
        this();
    }

    public static final class DispoApiConfigurationBuilder {
        private final DispoApiConfiguration config = new DispoApiConfiguration(null);

        public DispoApiConfiguration build() {
            return this.config.copy();
        }

        public DispoApiConfigurationBuilder properties(Map<String, Object> props) {
            this.fileExtRegex(DispoApiConfigurationBuilder.get(props, DispoConstants.FILE_EXT_REGEX, ""));
            this.resultsFileExtRegex(DispoApiConfigurationBuilder.get(props, DispoConstants.RESULTS_FILE_EXT_REGEX, ""));
            return this;
        }

        public DispoApiConfigurationBuilder fileExtRegex(String fileExtRegex) {
            this.config.setFileExtRegex(fileExtRegex);
            return this;
        }

        public DispoApiConfigurationBuilder resultsFileExtRegex(String resultsFileExtRegex) {
            this.config.setResultsFileExtRegex(resultsFileExtRegex);
            return this;
        }

        private static String get(Map<String, Object> props, String key, String defaultValue) {
            Object object;
            String toReturn = defaultValue;
            Object object2 = object = props != null ? props.get(key) : null;
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

