/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.HasLocalId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.data.HasDeleteState;
import org.eclipse.osee.orcs.data.Modifiable;

public final class OrcsPredicates {
    private OrcsPredicates() {
    }

    public static <T extends HasDeleteState> Predicate<T> includeDeleted() {
        return OrcsPredicates.deletionFlagEquals(DeletionFlag.INCLUDE_DELETED);
    }

    public static <T extends HasDeleteState> Predicate<T> excludeDeleted() {
        return OrcsPredicates.deletionFlagEquals(DeletionFlag.EXCLUDE_DELETED);
    }

    public static Predicate<Modifiable> isNotDirty() {
        return Predicates.not(OrcsPredicates.isDirty());
    }

    public static <T extends Modifiable> Predicate<T> isDirty() {
        return new Predicate<T>(){

            public boolean apply(T data) {
                return data.isDirty();
            }
        };
    }

    public static <T extends HasDeleteState> Predicate<T> deletionFlagEquals(DeletionFlag includeDeleted) {
        return new DeletedMatcher(includeDeleted);
    }

    public static Predicate<Attribute<String>> attributeStringEquals(String target) {
        return OrcsPredicates.attributeString(Predicates.equalTo((Object)target));
    }

    public static <T> Predicate<Attribute<T>> attributeValueEquals(T target) {
        return OrcsPredicates.attributeValue(Predicates.equalTo(target));
    }

    public static Predicate<Attribute<CharSequence>> attributeContainsPattern(String pattern) {
        return OrcsPredicates.attributeString(Predicates.containsPattern((String)pattern));
    }

    public static Predicate<Attribute<CharSequence>> attributeContainsPattern(Pattern pattern) {
        return OrcsPredicates.attributeString(Predicates.contains((Pattern)pattern));
    }

    public static <T extends CharSequence> Predicate<Attribute<T>> attributeString(Predicate<T> predicate) {
        return Predicates.compose(predicate, (Function)new Function<Attribute<T>, T>(){

            public T apply(Attribute<T> input) {
                Object value = null;
                try {
                    Object rawValue = input.getValue();
                    if (rawValue != null) {
                        value = this.asString(rawValue);
                    }
                }
                catch (OseeCoreException oseeCoreException) {}
                return value;
            }

            private T asString(Object rawValue) {
                return String.valueOf(rawValue);
            }
        });
    }

    public static <T> Predicate<Attribute<T>> attributeValue(Predicate<T> predicate) {
        return Predicates.compose(predicate, (Function)new Function<Attribute<T>, T>(){

            public T apply(Attribute<T> input) {
                Object value = null;
                try {
                    value = input.getValue();
                }
                catch (OseeCoreException oseeCoreException) {}
                return value;
            }
        });
    }

    public static Predicate<Attribute<?>> attributeId(final Integer attributeId) {
        return new Predicate<Attribute<?>>(){

            public boolean apply(Attribute<?> input) {
                return attributeId.equals(input.getLocalId());
            }
        };
    }

    public static Predicate<Relation> nodeIdOnSideEquals(final HasLocalId<Integer> localId, final RelationSide side) {
        return new Predicate<Relation>(){

            public boolean apply(Relation relation) {
                return relation.getLocalIdForSide(side).equals(localId.getLocalId());
            }
        };
    }

    public static Predicate<Relation> nodeIdsEquals(HasLocalId<Integer> aId, HasLocalId<Integer> bId) {
        return OrcsPredicates.nodeIdsEquals((Integer)aId.getLocalId(), (Integer)bId.getLocalId());
    }

    public static Predicate<Relation> nodeIdsEquals(final Integer aId, final Integer bId) {
        return new Predicate<Relation>(){

            public boolean apply(Relation relation) {
                return aId.equals(relation.getLocalIdForSide(RelationSide.SIDE_A)) && bId.equals(relation.getLocalIdForSide(RelationSide.SIDE_B));
            }
        };
    }

    private static class DeletedMatcher<T extends HasDeleteState>
    implements Predicate<T> {
        DeletionFlag flag;

        public DeletedMatcher(DeletionFlag includeDeleted) {
            this.flag = includeDeleted;
        }

        public boolean apply(T data) {
            boolean result = false;
            ModificationType modificationType = data.getModificationType();
            result = this.flag == DeletionFlag.INCLUDE_HARD_DELETED ? true : (this.flag == DeletionFlag.INCLUDE_DELETED && ModificationType.getAllNotHardDeletedTypes().contains(modificationType) ? true : !data.isDeleted());
            return result;
        }
    }
}

