/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.util;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;

public final class OrcsConditions {
    private OrcsConditions() {
    }

    public static void checkOnGraph(GraphData graph, RelationNode ... nodes) throws OseeCoreException {
        Conditions.checkNotNull((Object)graph, (String)"graph");
        RelationNode[] relationNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationNode node = relationNodeArray[n2];
            Conditions.checkNotNull((Object)node, (String)"node");
            GraphData graph2 = node.getGraph();
            Conditions.checkExpressionFailOnTrue((!graph.equals(graph2) ? 1 : 0) != 0, (String)"Error - Node[%s] is on graph[%s] but should be on graph[%s]", (Object[])new Object[]{node, graph2, graph});
            ++n2;
        }
    }

    public static void checkBranch(GraphData graph, RelationNode ... nodes) throws OseeCoreException {
        Conditions.checkNotNull((Object)graph, (String)"graph");
        RelationNode[] relationNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationNode node = relationNodeArray[n2];
            Conditions.checkNotNull((Object)node, (String)"node");
            GraphData graph2 = node.getGraph();
            Conditions.checkExpressionFailOnTrue((!graph.getBranch().equals(graph2.getBranch()) ? 1 : 0) != 0, (String)"Error - Node[%s] is on branch[%d] but should be on branch[%d]", (Object[])new Object[]{node, graph2.getBranch(), graph.getBranch()});
            ++n2;
        }
    }

    public static void checkBranch(RelationNode node1, RelationNode node2) throws OseeCoreException {
        boolean areEqual = node1.getBranch().equals(node2.getBranch());
        Conditions.checkExpressionFailOnTrue((!areEqual ? 1 : 0) != 0, (String)"Cross branch linking is not yet supported.", (Object[])new Object[0]);
    }

    public static void checkRelateSelf(RelationNode node1, RelationNode node2) throws OseeCoreException {
        Conditions.checkExpressionFailOnTrue((boolean)node1.equals(node2), (String)"Not valid to relate [%s] to itself", (Object[])new Object[]{node1});
    }
}

