/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class TokenTypeIndex<TOKEN extends Id, DSLTYPE> {
    private final Map<Long, TOKEN> uuidToToken = Maps.newHashMap();
    private final BiMap<TOKEN, DSLTYPE> tokenToType = HashBiMap.create();

    public Collection<TOKEN> getAllTokens() {
        return this.tokenToType.keySet();
    }

    public TOKEN get(Long id) {
        return (TOKEN)((Id)this.uuidToToken.get(id));
    }

    public TOKEN get(Id id) {
        return (TOKEN)((Id)this.uuidToToken.get(id.getId()));
    }

    public DSLTYPE getDslTypeByToken(Id key) {
        TOKEN tokenByUuid;
        Object type = this.tokenToType.get((Object)key);
        if (type == null && (tokenByUuid = this.get(key.getId())) != null) {
            type = this.tokenToType.get(tokenByUuid);
        }
        return (DSLTYPE)type;
    }

    public TOKEN getTokenByDslType(DSLTYPE value) {
        return (TOKEN)((Id)this.tokenToType.inverse().get(value));
    }

    public boolean existsByUuid(Long uuid) {
        return this.uuidToToken.containsKey(uuid);
    }

    public boolean exists(Id id) {
        return this.uuidToToken.containsKey(id.getId());
    }

    public void put(TOKEN token, DSLTYPE dslType) {
        this.uuidToToken.put(token.getId(), token);
        this.tokenToType.put(token, dslType);
    }

    public boolean isEmpty() {
        return this.uuidToToken.isEmpty();
    }

    public int size() {
        return this.uuidToToken.size();
    }
}

