/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.TokenTypeIndex;

public class RelationTypeIndex
extends TokenTypeIndex<RelationTypeToken, XRelationType> {
    private final ArtifactTypeIndex artifactTypeIndex;

    public RelationTypeIndex(ArtifactTypeIndex artifactTypeIndex) {
        this.artifactTypeIndex = artifactTypeIndex;
    }

    public IArtifactType getArtifactType(RelationTypeId relation, RelationSide relationSide) {
        XRelationType type = (XRelationType)this.getDslTypeByToken((Id)relation);
        XArtifactType artifactType = relationSide == RelationSide.SIDE_A ? type.getSideAArtifactType() : type.getSideBArtifactType();
        return (IArtifactType)this.artifactTypeIndex.getTokenByDslType(artifactType);
    }

    public boolean isArtifactTypeAllowed(RelationTypeId relation, RelationSide relationSide, IArtifactType artifactType) {
        IArtifactType allowedType = this.getArtifactType(relation, relationSide);
        return this.artifactTypeIndex.inheritsFrom((ArtifactTypeId)artifactType, new ArtifactTypeId[]{allowedType});
    }
}

