/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.core.dsl.OseeDslResource;
import org.eclipse.osee.framework.core.dsl.OseeDslResourceUtil;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AddAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AddEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AttributeOverrideOption;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDsl;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDslFactory;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OverrideOption;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RemoveAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RemoveEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.UpdateAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeTypeRef;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeArtifactTypeOverride;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumEntry;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumOverride;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.util.OseeDslSwitch;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.AttributeTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumEntryImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypeImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.RelationTypeIndex;
import org.eclipse.osee.orcs.data.EnumEntry;
import org.eclipse.osee.orcs.data.EnumType;

public class OrcsTypesIndexer {
    private final Log logger;
    private final BranchHierarchyProvider hierarchyProvider;

    public OrcsTypesIndexer(Log logger, BranchHierarchyProvider hierarchyProvider) {
        this.logger = logger;
        this.hierarchyProvider = hierarchyProvider;
    }

    public OrcsTypesIndex index(IResource source) throws Exception {
        OseeDslResource resource = null;
        InputStream inputStream = null;
        try {
            inputStream = source.getContent();
            inputStream = this.upConvertTo17(inputStream);
            resource = OseeDslResourceUtil.loadModel((String)source.getLocation().toASCIIString(), (InputStream)inputStream);
        }
        finally {
            Lib.close((Closeable)inputStream);
        }
        Conditions.checkNotNull((Object)resource, (String)"osee dsl model", (String)"Error reading osee dsl resource", (Object[])new Object[0]);
        OseeDsl model = resource.getModel();
        ArtifactTypeIndex artifactTypeIndex = new ArtifactTypeIndex(this.hierarchyProvider);
        AttributeTypeIndex attributeTypeIndex = new AttributeTypeIndex();
        EnumTypeIndex enumTypeIndex = new EnumTypeIndex();
        RelationTypeIndex relationTypeIndex = new RelationTypeIndex(artifactTypeIndex);
        OrcsIndeces index = new OrcsIndeces(source, artifactTypeIndex, attributeTypeIndex, enumTypeIndex, relationTypeIndex);
        for (XOseeArtifactTypeOverride xArtifactTypeOverride : model.getArtifactTypeOverrides()) {
            this.applyArtifactTypeOverrides(xArtifactTypeOverride);
        }
        for (XOseeEnumOverride xEnumOverride : model.getEnumOverrides()) {
            this.applyEnumOverrides(xEnumOverride);
        }
        for (XAttributeType dslType : model.getAttributeTypes()) {
            this.getOrCreateToken(attributeTypeIndex, dslType);
        }
        for (XAttributeType dslType : model.getArtifactTypes()) {
            IArtifactType token = this.getOrCreateToken(artifactTypeIndex, (XArtifactType)dslType);
            this.indexSuperTypes(artifactTypeIndex, token, (XArtifactType)dslType);
            this.indexAttributes(artifactTypeIndex, attributeTypeIndex, (XArtifactType)dslType);
        }
        for (XAttributeType dslType : model.getRelationTypes()) {
            this.getOrCreateToken(relationTypeIndex, (XRelationType)dslType);
        }
        for (XAttributeType dslType : model.getEnumTypes()) {
            this.getOrCreateEnumType(enumTypeIndex, (XOseeEnumType)dslType);
        }
        return index;
    }

    private InputStream upConvertTo17(InputStream inputStream) throws Exception {
        return OseeDslResourceUtil.upConvertTo17((InputStream)inputStream);
    }

    private void indexSuperTypes(ArtifactTypeIndex artifactTypeIndex, IArtifactType token, XArtifactType dslType) throws OseeCoreException {
        LinkedHashSet tokenSuperTypes = Sets.newLinkedHashSet();
        for (XArtifactType superTypes : dslType.getSuperArtifactTypes()) {
            IArtifactType superToken = this.getOrCreateToken(artifactTypeIndex, superTypes);
            tokenSuperTypes.add(superToken);
        }
        if (!tokenSuperTypes.isEmpty()) {
            artifactTypeIndex.put(token, tokenSuperTypes);
        }
    }

    private void indexAttributes(ArtifactTypeIndex artifactTypeIndex, AttributeTypeIndex attributeTypeIndex, XArtifactType dslType) throws OseeCoreException {
        HashMap<BranchId, Collection<AttributeTypeToken>> validAttributes = new HashMap<BranchId, Collection<AttributeTypeToken>>();
        for (XAttributeTypeRef xAttributeTypeRef : dslType.getValidAttributeTypes()) {
            XAttributeType xAttributeType = xAttributeTypeRef.getValidAttributeType();
            BranchId branch = this.getAttributeBranch(xAttributeTypeRef);
            AttributeTypeToken attributeType = (AttributeTypeToken)attributeTypeIndex.getTokenByDslType(xAttributeType);
            if (attributeType != null && attributeType.isValid()) {
                Collection listOfAllowedAttributes = (Collection)validAttributes.get(branch);
                if (listOfAllowedAttributes == null) {
                    listOfAllowedAttributes = Sets.newHashSet();
                    validAttributes.put(branch, listOfAllowedAttributes);
                }
                listOfAllowedAttributes.add(attributeType);
                continue;
            }
            this.logger.warn("Type was null for [%s]", new Object[]{dslType.getName()});
        }
        IArtifactType token = this.getOrCreateToken(artifactTypeIndex, dslType);
        artifactTypeIndex.put(token, (Map<BranchId, Collection<AttributeTypeToken>>)validAttributes);
    }

    private IArtifactType getOrCreateToken(ArtifactTypeIndex index, XArtifactType dslType) throws OseeCoreException {
        IArtifactType token = (IArtifactType)index.getTokenByDslType(dslType);
        if (token == null) {
            long id = Long.valueOf(dslType.getId());
            token = TokenFactory.createArtifactType((long)id, (String)dslType.getName());
            index.put(token, dslType);
        }
        return token;
    }

    private AttributeTypeId getOrCreateToken(AttributeTypeIndex index, XAttributeType dslType) throws OseeCoreException {
        AttributeTypeToken token = (AttributeTypeToken)index.getTokenByDslType(dslType);
        if (token == null) {
            long id = Long.valueOf(dslType.getId());
            token = AttributeTypeToken.valueOf((long)id, (String)dslType.getName());
            index.put(token, dslType);
        }
        return token;
    }

    private IRelationType getOrCreateToken(RelationTypeIndex index, XRelationType dslType) throws OseeCoreException {
        RelationTypeToken token = (RelationTypeToken)index.getTokenByDslType(dslType);
        if (token == null) {
            long id = Long.valueOf(dslType.getId());
            token = TokenFactory.createRelationType((long)id, (String)dslType.getName());
            index.put(token, dslType);
        }
        return token;
    }

    private EnumType getOrCreateEnumType(EnumTypeIndex index, XOseeEnumType dslType) throws OseeCoreException {
        EnumType item = (EnumType)index.getTokenByDslType(dslType);
        if (item == null) {
            item = this.createEnumType(dslType);
            index.put(item, dslType);
        }
        return item;
    }

    private EnumType createEnumType(XOseeEnumType dslType) throws OseeCoreException {
        int lastOrdinal = 0;
        LinkedList<EnumEntry> entries = new LinkedList<EnumEntry>();
        for (XOseeEnumEntry entry : dslType.getEnumEntries()) {
            String description;
            String ordinal = entry.getOrdinal();
            if (Strings.isValid((String)ordinal)) {
                lastOrdinal = Integer.parseInt(ordinal);
            }
            if ((description = entry.getDescription()) == null) {
                description = Strings.emptyString();
            }
            EnumEntryImpl enumEntry = new EnumEntryImpl(entry.getName(), lastOrdinal, description);
            entries.add(enumEntry);
            ++lastOrdinal;
        }
        Collections.sort(entries);
        Long uuid = Long.valueOf(dslType.getId());
        return new EnumTypeImpl(uuid, dslType.getName(), entries);
    }

    private BranchId getAttributeBranch(XAttributeTypeRef xAttributeTypeRef) {
        Long branchId;
        IOseeBranch branchToken = CoreBranches.SYSTEM_ROOT;
        if (Strings.isValid((String)xAttributeTypeRef.getBranchUuid()) && (branchId = Long.valueOf(xAttributeTypeRef.getBranchUuid())) > 0L) {
            branchToken = BranchId.valueOf((long)branchId);
        }
        return branchToken;
    }

    private void applyArtifactTypeOverrides(XOseeArtifactTypeOverride xArtTypeOverride) {
        XArtifactType xArtifactType = xArtTypeOverride.getOverridenArtifactType();
        final EList validAttributeTypes = xArtifactType.getValidAttributeTypes();
        if (!xArtTypeOverride.isInheritAll()) {
            validAttributeTypes.clear();
        }
        OseeDslSwitch<Void> overrideVisitor = new OseeDslSwitch<Void>(){

            public Void caseAddAttribute(AddAttribute addOption) {
                XAttributeTypeRef attributeRef = addOption.getAttribute();
                validAttributeTypes.add((Object)attributeRef);
                return (Void)super.caseAddAttribute(addOption);
            }

            public Void caseRemoveAttribute(RemoveAttribute removeOption) {
                XAttributeType attribute = removeOption.getAttribute();
                String guidToMatch = attribute.getId();
                LinkedList<XAttributeTypeRef> toRemove = new LinkedList<XAttributeTypeRef>();
                for (XAttributeTypeRef xAttributeTypeRef : validAttributeTypes) {
                    String itemGuid = xAttributeTypeRef.getValidAttributeType().getId();
                    if (!guidToMatch.equals(itemGuid)) continue;
                    toRemove.add(xAttributeTypeRef);
                }
                validAttributeTypes.removeAll(toRemove);
                return (Void)super.caseRemoveAttribute(removeOption);
            }

            public Void caseUpdateAttribute(UpdateAttribute updateAttribute) {
                XAttributeTypeRef refToUpdate = updateAttribute.getAttribute();
                String guidToMatch = refToUpdate.getValidAttributeType().getId();
                LinkedList<XAttributeTypeRef> toRemove = new LinkedList<XAttributeTypeRef>();
                for (XAttributeTypeRef xAttributeTypeRef : validAttributeTypes) {
                    String itemGuid = xAttributeTypeRef.getValidAttributeType().getId();
                    if (!guidToMatch.equals(itemGuid)) continue;
                    toRemove.add(xAttributeTypeRef);
                }
                validAttributeTypes.removeAll(toRemove);
                validAttributeTypes.add((Object)refToUpdate);
                return (Void)super.caseUpdateAttribute(updateAttribute);
            }
        };
        for (AttributeOverrideOption xOverrideOption : xArtTypeOverride.getOverrideOptions()) {
            overrideVisitor.doSwitch((EObject)xOverrideOption);
        }
    }

    private void applyEnumOverrides(XOseeEnumOverride xEnumOverride) {
        XOseeEnumType xEnumType = xEnumOverride.getOverridenEnumType();
        final EList enumEntries = xEnumType.getEnumEntries();
        if (!xEnumOverride.isInheritAll()) {
            enumEntries.clear();
        }
        OseeDslSwitch<Void> overrideVisitor = new OseeDslSwitch<Void>(){

            public Void caseAddEnum(AddEnum addEnum) {
                String entryName = addEnum.getEnumEntry();
                String description = addEnum.getDescription();
                XOseeEnumEntry xEnumEntry = OseeDslFactory.eINSTANCE.createXOseeEnumEntry();
                xEnumEntry.setName(entryName);
                xEnumEntry.setDescription(description);
                enumEntries.add((Object)xEnumEntry);
                return (Void)super.caseAddEnum(addEnum);
            }

            public Void caseRemoveEnum(RemoveEnum removeEnum) {
                XOseeEnumEntry enumEntry = removeEnum.getEnumEntry();
                String nameToMatch = enumEntry.getName();
                LinkedList<XOseeEnumEntry> toRemove = new LinkedList<XOseeEnumEntry>();
                for (XOseeEnumEntry item : enumEntries) {
                    String toMatch = item.getName();
                    if (!nameToMatch.equals(toMatch)) continue;
                    toRemove.add(item);
                }
                enumEntries.removeAll(toRemove);
                return (Void)super.caseRemoveEnum(removeEnum);
            }
        };
        for (OverrideOption xOverrideOption : xEnumOverride.getOverrideOptions()) {
            overrideVisitor.doSwitch((EObject)xOverrideOption);
        }
    }

    private static final class OrcsIndeces
    implements OrcsTypesIndex {
        private final IResource resource;
        private final ArtifactTypeIndex artifactTypeIndex;
        private final AttributeTypeIndex attributeTypeIndex;
        private final EnumTypeIndex enumTypeIndex;
        private final RelationTypeIndex relationTypeIndex;

        public OrcsIndeces(IResource resource, ArtifactTypeIndex artifactTypeIndex, AttributeTypeIndex attributeTypeIndex, EnumTypeIndex enumTypeIndex, RelationTypeIndex relationTypeIndex) {
            this.resource = resource;
            this.artifactTypeIndex = artifactTypeIndex;
            this.attributeTypeIndex = attributeTypeIndex;
            this.enumTypeIndex = enumTypeIndex;
            this.relationTypeIndex = relationTypeIndex;
        }

        @Override
        public ArtifactTypeIndex getArtifactTypeIndex() {
            return this.artifactTypeIndex;
        }

        @Override
        public AttributeTypeIndex getAttributeTypeIndex() {
            return this.attributeTypeIndex;
        }

        @Override
        public RelationTypeIndex getRelationTypeIndex() {
            return this.relationTypeIndex;
        }

        @Override
        public EnumTypeIndex getEnumTypeIndex() {
            return this.enumTypeIndex;
        }

        @Override
        public IResource getOrcsTypesResource() {
            return this.resource;
        }
    }
}

