/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndexProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoaderFactory;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesResourceProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.AttributeTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.RelationTypesImpl;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumTypes;
import org.eclipse.osee.orcs.data.RelationTypes;

public class OrcsTypesImpl
implements OrcsTypes {
    private final OrcsTypesIndexProvider indexProvider;
    private final Log logger;
    private final OrcsSession session;
    private final OrcsTypesDataStore dataStore;
    private final OrcsTypesLoaderFactory loaderFactory;
    private final ArtifactTypes artifactTypes;
    private final AttributeTypes attributeTypes;
    private final RelationTypes relationTypes;
    private final EnumTypes enumTypes;

    public OrcsTypesImpl(Log logger, OrcsSession session, OrcsTypesDataStore dataStore, OrcsTypesLoaderFactory loaderFactory, OrcsTypesIndexProvider indexProvider) {
        this.logger = logger;
        this.session = session;
        this.dataStore = dataStore;
        this.loaderFactory = loaderFactory;
        this.indexProvider = indexProvider;
        this.artifactTypes = new ArtifactTypesImpl(indexProvider);
        this.attributeTypes = new AttributeTypesImpl(indexProvider, indexProvider);
        this.relationTypes = new RelationTypesImpl(indexProvider);
        this.enumTypes = new EnumTypesImpl(indexProvider);
    }

    public ArtifactTypes getArtifactTypes() {
        return this.artifactTypes;
    }

    public AttributeTypes getAttributeTypes() {
        return this.attributeTypes;
    }

    public RelationTypes getRelationTypes() {
        return this.relationTypes;
    }

    public EnumTypes getEnumTypes() {
        return this.enumTypes;
    }

    public void invalidateAll() {
        this.indexProvider.invalidate();
    }

    public Callable<Void> loadTypes(final IResource resource) {
        return new CancellableCallable<Void>(){

            public Void call() throws Exception {
                OrcsTypesImpl.this.indexProvider.setLoader(OrcsTypesImpl.this.loaderFactory.createTypesLoader(OrcsTypesImpl.this.session, new OrcsTypesResourceProvider(){

                    @Override
                    public IResource getOrcsTypesResource() {
                        return resource;
                    }
                }));
                return null;
            }
        };
    }

    public Callable<Void> writeTypes(final OutputStream outputStream) {
        return new CancellableCallable<Void>(){

            public Void call() throws Exception {
                OrcsTypesImpl.this.logger.trace("Writing OrcsTypes for session [%s]", new Object[]{OrcsTypesImpl.this.session});
                IResource resource = OrcsTypesImpl.this.indexProvider.getOrcsTypesResource();
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = resource.getContent();
                        this.checkForCancelled();
                        Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Exception ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                        Lib.close((Closeable)inputStream);
                        Lib.close((Closeable)outputStream);
                    }
                }
                finally {
                    Lib.close((Closeable)inputStream);
                    Lib.close((Closeable)outputStream);
                }
                return null;
            }
        };
    }

    public Callable<Void> purgeArtifactsByArtifactType(Collection<? extends IArtifactType> artifactTypes) {
        return this.dataStore.purgeArtifactsByArtifactType(this.session, artifactTypes);
    }

    public Callable<Void> purgeAttributesByAttributeType(Collection<? extends AttributeTypeId> attributeTypes) {
        return this.dataStore.purgeAttributesByAttributeType(this.session, attributeTypes);
    }

    public Callable<Void> purgeRelationsByRelationType(Collection<? extends IRelationType> relationTypes) {
        return this.dataStore.purgeRelationsByRelationType(this.session, relationTypes);
    }
}

