/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.base.Stopwatch;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndex;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesResourceProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesIndexer;

public class CreateOrcsTypesIndexCallable
extends CancellableCallable<OrcsTypesIndex> {
    private final Log logger;
    private final OrcsTypesIndexer indexer;
    private final OrcsTypesResourceProvider provider;

    public CreateOrcsTypesIndexCallable(Log logger, OrcsTypesIndexer indexer, OrcsTypesResourceProvider provider) {
        this.logger = logger;
        this.indexer = indexer;
        this.provider = provider;
    }

    public OrcsTypesIndex call() throws Exception {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        OrcsTypesIndex index = null;
        try {
            index = this.createIndex();
        }
        catch (Throwable throwable) {
            this.logger.trace("Created OrcsTypesIndex in [%s]", new Object[]{Lib.getElapseString((long)stopwatch.elapsedMillis())});
            stopwatch.stop();
            throw throwable;
        }
        this.logger.trace("Created OrcsTypesIndex in [%s]", new Object[]{Lib.getElapseString((long)stopwatch.elapsedMillis())});
        stopwatch.stop();
        return index;
    }

    private OrcsTypesIndex createIndex() throws Exception {
        long startTime = System.currentTimeMillis();
        IResource source = this.provider.getOrcsTypesResource();
        this.checkForCancelled();
        this.logger.trace("Read OrcsTypes from datastore in [%s]", new Object[]{Lib.getElapseString((long)startTime)});
        OrcsTypesIndex index = this.indexer.index(source);
        return index;
    }
}

