/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.internal.types.impl.AttributeTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypeIndex;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumType;

public class AttributeTypesImpl
implements AttributeTypes {
    private static final String ATTRIBUTE_OCCURRENCE_UNLIMITED = "unlimited";
    private static final String BASE_TYPE_NAMESPACE = "org.eclipse.osee.framework.skynet.core.";
    private final AttributeTypeIndexProvider provider;
    private final EnumTypeIndexProvider enumTypeIndexProvider;

    public AttributeTypesImpl(AttributeTypeIndexProvider provider, EnumTypeIndexProvider enumTypeIndexProvider) {
        this.provider = provider;
        this.enumTypeIndexProvider = enumTypeIndexProvider;
    }

    private XAttributeType getType(AttributeTypeId attributeType) throws OseeCoreException {
        return (XAttributeType)this.provider.getAttributeTypeIndex().getDslTypeByToken((Id)attributeType);
    }

    public Collection<AttributeTypeToken> getAll() throws OseeCoreException {
        return this.provider.getAttributeTypeIndex().getAllTokens();
    }

    public AttributeTypeToken get(Id id) {
        return (AttributeTypeToken)this.provider.getAttributeTypeIndex().get(id);
    }

    public AttributeTypeToken get(Long id) {
        return (AttributeTypeToken)this.provider.getAttributeTypeIndex().get(id);
    }

    private String getQualifiedTypeName(String id) {
        String value;
        String string = value = !Strings.isValid((String)id) ? Strings.emptyString() : id;
        if (!value.contains(".")) {
            value = BASE_TYPE_NAMESPACE + id;
        }
        return value;
    }

    public String getBaseAttributeTypeId(AttributeTypeId attributeType) throws OseeCoreException {
        return this.getQualifiedTypeName(this.getType(attributeType).getBaseAttributeType());
    }

    public String getAttributeProviderId(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        return this.getQualifiedTypeName(type.getDataProvider());
    }

    public String getDefaultValue(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        return type.getDefaultValue();
    }

    public int getMaxOccurrences(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        String maxValue = type.getMax();
        int max = Integer.MAX_VALUE;
        if (!ATTRIBUTE_OCCURRENCE_UNLIMITED.equals(maxValue) && Strings.isValid((String)maxValue)) {
            max = Integer.parseInt(maxValue);
        }
        return max;
    }

    public int getMinOccurrences(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        String minValue = type.getMin();
        int min = 0;
        if (Strings.isValid((String)minValue)) {
            min = Integer.parseInt(minValue);
        }
        return min;
    }

    public String getFileTypeExtension(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        String value = type.getFileExtension();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public String getTaggerId(AttributeTypeId attributeType) {
        XAttributeType type = this.getType(attributeType);
        String value = type.getTaggerId();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public boolean isTaggable(AttributeTypeId attributeType) {
        boolean toReturn = false;
        String taggerId = this.getTaggerId(attributeType);
        if (taggerId != null) {
            toReturn = Strings.isValid((String)taggerId.trim());
        }
        return toReturn;
    }

    public boolean isEnumerated(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        XOseeEnumType enumType = type.getEnumType();
        return enumType != null;
    }

    public EnumType getEnumType(AttributeTypeId attrType) throws OseeCoreException {
        EnumType toReturn = null;
        XAttributeType type = this.getType(attrType);
        XOseeEnumType enumType = type.getEnumType();
        if (enumType != null) {
            toReturn = (EnumType)this.enumTypeIndexProvider.getEnumTypeIndex().getTokenByDslType(enumType);
        }
        return toReturn;
    }

    public String getDescription(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        String value = type.getDescription();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public boolean isEmpty() throws OseeCoreException {
        return this.provider.getAttributeTypeIndex().isEmpty();
    }

    public int size() throws OseeCoreException {
        return this.provider.getAttributeTypeIndex().size();
    }

    public Collection<AttributeTypeId> getAllTaggable() throws OseeCoreException {
        return this.provider.getAttributeTypeIndex().getAllTaggable();
    }

    public boolean exists(Id id) throws OseeCoreException {
        return this.provider.getAttributeTypeIndex().exists(id);
    }

    public String getMediaType(AttributeTypeId attrType) throws OseeCoreException {
        XAttributeType type = this.getType(attrType);
        String value = type.getMediaType();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public boolean hasMediaType(AttributeTypeId attrType) throws OseeCoreException {
        boolean toReturn = false;
        String mediaType = this.getMediaType(attrType);
        if (mediaType != null) {
            toReturn = Strings.isValid((String)mediaType.trim());
        }
        return toReturn;
    }

    public boolean isBooleanType(AttributeTypeId attrType) throws OseeCoreException {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("boolean");
    }

    public boolean isIntegerType(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("integer");
    }

    public boolean isDateType(AttributeTypeId attributeType) {
        String baseType = this.getBaseAttributeTypeId(attributeType);
        return baseType != null && baseType.toLowerCase().contains("date");
    }

    public boolean isFloatingType(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("floatingpoint");
    }

    public AttributeTypeId getByName(String attrTypeName) {
        AttributeTypeToken attrType = null;
        for (AttributeTypeToken type : this.getAll()) {
            if (!type.getName().equals(attrTypeName)) continue;
            attrType = type;
            break;
        }
        return attrType;
    }

    public static interface AttributeTypeIndexProvider {
        public AttributeTypeIndex getAttributeTypeIndex() throws OseeCoreException;
    }

    public static interface EnumTypeIndexProvider {
        public EnumTypeIndex getEnumTypeIndex() throws OseeCoreException;
    }
}

