/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypeIndex;
import org.eclipse.osee.orcs.data.ArtifactTypes;

public class ArtifactTypesImpl
implements ArtifactTypes {
    private final ArtifactTypeIndexProvider provider;

    public ArtifactTypesImpl(ArtifactTypeIndexProvider provider) {
        this.provider = provider;
    }

    private ArtifactTypeIndex getArtifactTypesIndex() throws OseeCoreException {
        return this.provider.getArtifactTypeIndex();
    }

    private XArtifactType getType(IArtifactType artType) throws OseeCoreException {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        return (XArtifactType)this.getArtifactTypesIndex().getDslTypeByToken((Id)artType);
    }

    public Collection<IArtifactType> getAll() throws OseeCoreException {
        return this.getArtifactTypesIndex().getAllTokens();
    }

    public IArtifactType get(Id id) {
        return (IArtifactType)this.getArtifactTypesIndex().get(id);
    }

    public IArtifactType get(Long id) {
        return (IArtifactType)this.getArtifactTypesIndex().get(id);
    }

    public boolean isAbstract(IArtifactType artType) throws OseeCoreException {
        XArtifactType type = this.getType(artType);
        return type.isAbstract();
    }

    public boolean hasSuperArtifactTypes(IArtifactType artType) throws OseeCoreException {
        return !this.getSuperArtifactTypes(artType).isEmpty();
    }

    public Collection<? extends IArtifactType> getSuperArtifactTypes(IArtifactType artType) throws OseeCoreException {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        return this.getArtifactTypesIndex().getSuperTypes((ArtifactTypeId)artType);
    }

    public boolean inheritsFrom(ArtifactTypeId thisType, ArtifactTypeId ... otherTypes) throws OseeCoreException {
        Conditions.checkNotNull((Object)thisType, (String)"thisArtifactType");
        Conditions.checkNotNull((Object)otherTypes, (String)"otherArtifactTypes");
        return this.getArtifactTypesIndex().inheritsFrom(thisType, otherTypes);
    }

    public Collection<? extends IArtifactType> getAllDescendantTypes(ArtifactTypeId artType) {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        LinkedHashSet descendants = Sets.newLinkedHashSet();
        this.walkDescendants(artType, descendants);
        return descendants;
    }

    private void walkDescendants(ArtifactTypeId artifactType, Collection<IArtifactType> descendants) {
        Collection<IArtifactType> childTypes = this.getArtifactTypesIndex().getDescendantTypes(artifactType);
        if (!childTypes.isEmpty()) {
            for (IArtifactType type : childTypes) {
                this.walkDescendants((ArtifactTypeId)type, descendants);
                descendants.add(type);
            }
        }
    }

    public boolean isValidAttributeType(IArtifactType artType, BranchId branch, AttributeTypeId attributeType) throws OseeCoreException {
        Collection<AttributeTypeToken> attributes = this.getAttributeTypes(artType, branch);
        return attributes.contains(attributeType);
    }

    public Collection<AttributeTypeToken> getAttributeTypes(IArtifactType artType, BranchId branch) throws OseeCoreException {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return this.getArtifactTypesIndex().getAttributeTypes(artType, branch);
    }

    public boolean isEmpty() throws OseeCoreException {
        return this.getArtifactTypesIndex().isEmpty();
    }

    public int size() throws OseeCoreException {
        return this.getArtifactTypesIndex().size();
    }

    public boolean exists(Id id) throws OseeCoreException {
        return this.getArtifactTypesIndex().exists(id);
    }

    public Map<BranchId, Collection<AttributeTypeToken>> getAllAttributeTypes(IArtifactType artType) throws OseeCoreException {
        return this.getArtifactTypesIndex().getAllAttributeTypes((ArtifactTypeId)artType);
    }

    public static interface ArtifactTypeIndexProvider {
        public ArtifactTypeIndex getArtifactTypeIndex() throws OseeCoreException;
    }
}

