/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.TokenTypeIndex;

public class ArtifactTypeIndex
extends TokenTypeIndex<IArtifactType, XArtifactType> {
    private final Map<IArtifactType, ArtifactTypeMetaData> tokenToTypeData = Maps.newHashMap();
    private final BranchHierarchyProvider hierarchyProvider;

    public ArtifactTypeIndex(BranchHierarchyProvider hierarchyProvider) {
        this.hierarchyProvider = hierarchyProvider;
    }

    @Override
    public void put(IArtifactType type, Set<IArtifactType> superTypes) {
        ArtifactTypeMetaData metaData = this.getOrCreateData(type);
        metaData.setSuperTypes(superTypes);
    }

    @Override
    public void put(IArtifactType type, Map<BranchId, Collection<AttributeTypeToken>> attributes) {
        ArtifactTypeMetaData metaData = this.getOrCreateData(type);
        metaData.setAttributeTypes(attributes);
    }

    private ArtifactTypeMetaData getOrCreateData(IArtifactType type) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(type);
        if (metaData == null) {
            metaData = new ArtifactTypeMetaData(type);
            this.tokenToTypeData.put(type, metaData);
        }
        return metaData;
    }

    public Map<BranchId, Collection<AttributeTypeToken>> getAllAttributeTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData.attributeTypes;
    }

    public Collection<IArtifactType> getSuperTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData != null ? metaData.getSuperTypes() : Collections.emptyList();
    }

    public Collection<IArtifactType> getDescendantTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData != null ? metaData.getDescendantTypes() : Collections.emptyList();
    }

    public boolean hasSuperArtifactTypes(IArtifactType artType) {
        return !this.getSuperTypes((ArtifactTypeId)artType).isEmpty();
    }

    public boolean inheritsFrom(ArtifactTypeId thisType, ArtifactTypeId ... otherTypes) {
        boolean result = false;
        ArtifactTypeId[] artifactTypeIdArray = otherTypes;
        int n = otherTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeId otherType = artifactTypeIdArray[n2];
            if (this.inheritsFromSingle(thisType, otherType)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private boolean inheritsFromSingle(ArtifactTypeId thisType, ArtifactTypeId otherType) {
        boolean result = false;
        if (thisType.equals(otherType)) {
            result = true;
        } else {
            for (IArtifactType superType : this.getSuperTypes(thisType)) {
                if (!this.inheritsFrom((ArtifactTypeId)superType, otherType)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Collection<AttributeTypeToken> getAttributeTypes(IArtifactType artType, BranchId branch) throws OseeCoreException {
        LinkedHashSet attributeTypes = Sets.newLinkedHashSet();
        this.getAttributeTypes(attributeTypes, artType, branch);
        return attributeTypes;
    }

    private void getAttributeTypes(Set<AttributeTypeToken> attributeTypes, IArtifactType artifactType, BranchId branch) throws OseeCoreException {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        if (metaData != null) {
            Map<BranchId, Collection<AttributeTypeToken>> validityMap = metaData.getAttributeTypes();
            Iterable<? extends BranchId> branches = this.hierarchyProvider.getParentHierarchy(branch);
            for (BranchId branchId : branches) {
                Collection<AttributeTypeToken> items = validityMap.get(branchId);
                if (items == null) continue;
                attributeTypes.addAll(items);
            }
        }
        for (IArtifactType superType : this.getSuperTypes((ArtifactTypeId)artifactType)) {
            this.getAttributeTypes(attributeTypes, superType, branch);
        }
    }

    private final class ArtifactTypeMetaData {
        private final IArtifactType type;
        private Set<IArtifactType> superTypes;
        private final Set<IArtifactType> descendantTypes;
        private Map<BranchId, Collection<AttributeTypeToken>> attributeTypes;

        public ArtifactTypeMetaData(IArtifactType type) {
            this.type = type;
            this.superTypes = Collections.emptySet();
            this.descendantTypes = Sets.newLinkedHashSet();
            this.attributeTypes = Collections.emptyMap();
        }

        public void setSuperTypes(Set<IArtifactType> newSuperTypes) {
            ArtifactTypeMetaData metaData;
            HashSet originals = Sets.newHashSet(this.superTypes);
            this.superTypes = Sets.newHashSet(newSuperTypes);
            for (IArtifactType superType : this.superTypes) {
                metaData = ArtifactTypeIndex.this.getOrCreateData(superType);
                if (metaData == null) continue;
                metaData.getDescendantTypes().add(this.type);
            }
            for (IArtifactType oldValue : originals) {
                metaData = ArtifactTypeIndex.this.getOrCreateData(oldValue);
                if (metaData == null) continue;
                metaData.getDescendantTypes().remove(this.type);
            }
        }

        public void setAttributeTypes(Map<BranchId, Collection<AttributeTypeToken>> attributes) {
            this.attributeTypes = attributes;
        }

        public Set<IArtifactType> getSuperTypes() {
            return this.superTypes;
        }

        public Set<IArtifactType> getDescendantTypes() {
            return this.descendantTypes;
        }

        public Map<BranchId, Collection<AttributeTypeToken>> getAttributeTypes() {
            return this.attributeTypes;
        }
    }
}

