/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphAdjacencies;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.transaction.ChangeSetBuilder;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.tuple.TupleManager;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class TxDataManager {
    private final ExternalArtifactManager proxyManager;
    private final ArtifactFactory artifactFactory;
    private final RelationManager relationManager;
    private final TupleManager tupleManager;
    private final TxDataLoader loader;

    public TxDataManager(ExternalArtifactManager proxyManager, ArtifactFactory artifactFactory, RelationManager relationManager, TupleManager tupleManager, TxDataLoader loader) {
        this.proxyManager = proxyManager;
        this.artifactFactory = artifactFactory;
        this.relationManager = relationManager;
        this.loader = loader;
        this.tupleManager = tupleManager;
    }

    public TxData createTxData(OrcsSession session, BranchId branch) throws OseeCoreException {
        GraphData graphData = this.loader.createGraph(session, branch);
        return new TxData(session, graphData);
    }

    public void txCommitSuccess(TxData txData) {
        GraphData graph = txData.getGraph();
        for (Artifact writeable : txData.getAllWriteables()) {
            writeable.setNotDirty();
            RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies(writeable);
            for (Relation relation : adjacencies.getDirties()) {
                relation.clearDirty();
            }
        }
        txData.setTxState(TxData.TxState.COMMITTED);
    }

    public void rollbackTx(TxData txData) {
        txData.setTxState(TxData.TxState.COMMIT_FAILED);
    }

    public void startTx(TxData txData) throws OseeCoreException {
        Conditions.checkExpressionFailOnTrue((boolean)txData.isCommitInProgress(), (String)"Commit is already in progress", (Object[])new Object[0]);
        txData.setCommitInProgress(true);
        txData.setTxState(TxData.TxState.COMMIT_STARTED);
    }

    public void endTx(TxData txData) {
        txData.setCommitInProgress(false);
    }

    public Iterable<Artifact> getForWrite(TxData txData, Iterable<? extends ArtifactId> ids) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        LinkedHashSet<ArtifactId> toLoad = new LinkedHashSet<ArtifactId>();
        LinkedHashMap<String, Artifact> items = new LinkedHashMap<String, Artifact>();
        for (ArtifactId artifactId : ids) {
            Artifact node = this.findArtifactLocallyForWrite(txData, artifactId);
            if (node == null) {
                toLoad.add(artifactId);
            } else {
                this.checkAndAdd(txData, node);
            }
            items.put((String)artifactId.getGuid(), node);
        }
        if (!toLoad.isEmpty()) {
            ResultSet<Artifact> resultSet = this.loader.loadArtifacts(txData.getSession(), txData.getGraph(), toLoad);
            for (Artifact node : resultSet) {
                items.put((String)node.getGuid(), node);
                this.checkAndAdd(txData, node);
            }
        }
        return items.values();
    }

    public Artifact getForWrite(TxData txData, ArtifactId artifactId) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact node = this.findArtifactLocallyForWrite(txData, artifactId);
        if (node == null) {
            ResultSet<Artifact> result = this.loader.loadArtifacts(txData.getSession(), txData.getGraph(), Collections.singleton(artifactId));
            node = (Artifact)result.getExactlyOne();
        }
        this.checkAndAdd(txData, node);
        return node;
    }

    private Artifact findArtifactLocallyForWrite(TxData txData, ArtifactId artifactId) throws OseeCoreException {
        Artifact node = txData.getWriteable(artifactId);
        if (node == null) {
            Artifact source = null;
            if (artifactId instanceof Artifact) {
                source = (Artifact)artifactId;
            } else if (artifactId instanceof ArtifactReadable) {
                ArtifactReadable readable = (ArtifactReadable)artifactId;
                source = this.proxyManager.asInternalArtifact(readable);
            }
            if (this.isFromSameStripe(txData, source) && this.includesDeletedData(source)) {
                node = this.copyArtifactForWrite(txData, source);
            }
        }
        return node;
    }

    private boolean isFromSameStripe(TxData txData, Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        return artifact.getTransaction().equals(txData.getGraph().getTransaction());
    }

    private boolean includesDeletedData(Artifact artifact) {
        boolean result = false;
        if (artifact != null) {
            result = true;
        }
        return result;
    }

    private Artifact copyArtifactForWrite(TxData txData, Artifact source) throws OseeCoreException {
        Artifact artifact = this.artifactFactory.clone(txData.getSession(), source);
        txData.getGraph().addNode(artifact, ((ArtifactData)artifact.getOrcsData()).isExistingVersionUsed());
        this.relationManager.cloneRelations(txData.getSession(), source, artifact);
        return artifact;
    }

    private Artifact getSourceArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId) throws OseeCoreException {
        Artifact source = null;
        if (txData.isOnBranch(fromBranch)) {
            source = txData.getWriteable(artifactId);
        }
        if (source == null) {
            ArtifactReadable external;
            Artifact artifactSrc = null;
            if (artifactId instanceof Artifact) {
                Artifact external2 = (Artifact)artifactId;
                if (fromBranch.equals(external2.getBranch())) {
                    artifactSrc = external2;
                }
            } else if (artifactId instanceof ArtifactReadable && fromBranch.equals((external = (ArtifactReadable)artifactId).getBranch())) {
                artifactSrc = this.proxyManager.asInternalArtifact(external);
            }
            if (this.includesDeletedData(artifactSrc)) {
                source = artifactSrc;
            }
        }
        if (source == null) {
            ResultSet<Artifact> loadArtifacts = this.loader.loadArtifacts(txData.getSession(), fromBranch, Collections.singleton(artifactId));
            source = (Artifact)loadArtifacts.getExactlyOne();
        }
        return source;
    }

    private void checkChangesAllowed(TxData txData) throws OseeCoreException {
        String errorMessage = "";
        if (txData.isCommitInProgress() || TxData.TxState.COMMIT_STARTED == txData.getTxState()) {
            errorMessage = "Changes are not allowed - [COMMIT_IN_PROGRESS]";
        }
        if (Strings.isValid((String)errorMessage)) {
            throw new OseeStateException(errorMessage, new Object[0]);
        }
    }

    public void setComment(TxData txData, String comment) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        txData.setComment(comment);
    }

    public void setAuthor(TxData txData, ArtifactId author) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        txData.setAuthor(author);
    }

    public Long createTuple2(TxData txData, BranchId branch, Long tupleTypeId, Long element1, Long element2) {
        return this.tupleManager.addTupple2(txData, branch, tupleTypeId, element1, element2);
    }

    public Long createTuple3(TxData txData, BranchId branch, Long tupleTypeId, Long e1, Long e2, Long e3) {
        return this.tupleManager.addTupple3(txData, branch, tupleTypeId, e1, e2, e3);
    }

    public Long createTuple4(TxData txData, BranchId branch, Long tupleTypeId, Long e1, Long e2, Long e3, Long e4) {
        return this.tupleManager.addTupple4(txData, branch, tupleTypeId, e1, e2, e3, e4);
    }

    public ArtifactReadable createArtifact(TxData txData, IArtifactType artifactType, String name, String guid) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, guid);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable createArtifact(TxData txData, IArtifactType artifactType, String name, String guid, long uuid) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, guid, uuid);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable copyArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact source = this.getSourceArtifact(txData, fromBranch, artifactId);
        return this.copyArtifactHelper(txData, source, source.getExistingAttributeTypes());
    }

    public ArtifactReadable copyArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId, Collection<AttributeTypeId> attributesToDuplicate) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact source = this.getSourceArtifact(txData, fromBranch, artifactId);
        return this.copyArtifactHelper(txData, source, attributesToDuplicate);
    }

    private ArtifactReadable copyArtifactHelper(TxData txData, Artifact source, Collection<? extends AttributeTypeId> attributesToDuplicate) throws OseeCoreException {
        Artifact copy = this.artifactFactory.copyArtifact(txData.getSession(), source, attributesToDuplicate, txData.getBranch());
        return this.asExternalArtifact(txData, copy);
    }

    public ArtifactReadable introduceArtifact(TxData txData, BranchId fromBranch, ArtifactReadable source, ArtifactReadable destination) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact src = this.getSourceArtifact(txData, fromBranch, (ArtifactId)source);
        Artifact dest = null;
        if (destination == null) {
            dest = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), src.getArtifactType(), (String)src.getGuid());
            dest.setGraph(this.loader.createGraph(txData.getSession(), txData.getBranch()));
        } else {
            dest = this.getSourceArtifact(txData, fromBranch, (ArtifactId)destination);
        }
        this.artifactFactory.introduceArtifact(txData.getSession(), src, dest, txData.getBranch());
        this.relationManager.introduce(txData.getSession(), txData.getBranch(), src, dest);
        this.addAdjacencies(txData, dest);
        return this.asExternalArtifact(txData, dest);
    }

    public ArtifactReadable replaceWithVersion(TxData txData, BranchId fromBranch, ArtifactReadable readable, ArtifactReadable destination) throws OseeCoreException {
        return this.introduceArtifact(txData, fromBranch, readable, destination);
    }

    private void addAdjacencies(TxData txData, Artifact dest) {
        GraphData destGraph = dest.getGraph();
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)destGraph.getAdjacencies(dest);
        GraphData graph = txData.getGraph();
        if (adjacencies != null) {
            for (Relation rel : adjacencies.getAll()) {
                graph.addAdjacencies(rel.getLocalIdForSide(RelationSide.SIDE_A), (GraphAdjacencies)adjacencies);
            }
        }
    }

    private ArtifactReadable asExternalArtifact(TxData txData, Artifact artifact) throws OseeCoreException {
        this.checkAndAdd(txData, artifact);
        ArtifactReadable readable = txData.getReadable(artifact);
        if (readable == null) {
            readable = this.proxyManager.asExternalArtifact(txData.getSession(), artifact);
            txData.add(readable);
        }
        return readable;
    }

    private void checkAndAdd(TxData txData, Artifact artifact) throws OseeCoreException {
        this.checkChangesAllowed(txData);
        Artifact oldArtifact = txData.add(artifact);
        boolean isDifferent = oldArtifact != null && !oldArtifact.equals(artifact);
        Conditions.checkExpressionFailOnTrue((boolean)isDifferent, (String)"Another instance of writeable detected - writeable tracking would be inconsistent", (Object[])new Object[0]);
        txData.getGraph().addNode(artifact, ((ArtifactData)artifact.getOrcsData()).isExistingVersionUsed());
    }

    public void deleteArtifact(TxData txData, ArtifactId sourceArtifact) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(txData, sourceArtifact);
        this.relationManager.unrelateFromAll(txData.getSession(), asArtifact);
        asArtifact.delete();
    }

    public void addChildren(TxData txData, ArtifactId artA, Iterable<? extends ArtifactId> children) throws OseeCoreException {
        OrcsSession session = txData.getSession();
        Artifact asArtifact = this.getForWrite(txData, artA);
        Iterable<Artifact> artifacts = this.getForWrite(txData, children);
        LinkedList nodes = Lists.newLinkedList(artifacts);
        this.relationManager.addChildren(session, asArtifact, nodes);
    }

    public void relate(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, (RelationTypeId)type, asArtifactB);
    }

    public void relate(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB, String rationale) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), (RelationNode)asArtifactA, (RelationTypeId)type, (RelationNode)asArtifactB, rationale);
    }

    public void relate(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB, RelationSorter sortType) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), (RelationNode)asArtifactA, (RelationTypeId)type, (RelationNode)asArtifactB, sortType);
    }

    public void relate(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB, String rationale, RelationSorter sortType) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, (RelationTypeId)type, asArtifactB, rationale, sortType);
    }

    public void setRelations(TxData txData, ArtifactId artA, IRelationType type, Iterable<? extends ArtifactId> artBs) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        LinkedHashSet asArtifactBs = Sets.newLinkedHashSet(this.getForWrite(txData, artBs));
        OrcsSession session = txData.getSession();
        ResultSet related = this.relationManager.getRelated(session, (RelationTypeId)type, asArtifactA, RelationSide.SIDE_A);
        LinkedHashSet relatedArtBs = Sets.newLinkedHashSet(this.getForWrite(txData, (Iterable<? extends ArtifactId>)related));
        for (Artifact asArtifactB : Sets.difference((Set)asArtifactBs, (Set)relatedArtBs)) {
            this.relationManager.relate(session, asArtifactA, (RelationTypeId)type, asArtifactB);
        }
        for (Artifact asArtifactB : Sets.difference((Set)relatedArtBs, (Set)asArtifactBs)) {
            this.relationManager.unrelate(session, asArtifactA, (RelationTypeId)type, asArtifactB);
        }
    }

    public void setRationale(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB, String rationale) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.setRationale(txData.getSession(), asArtifactA, (RelationTypeId)type, asArtifactB, rationale);
    }

    public void unrelate(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.unrelate(txData.getSession(), asArtifactA, (RelationTypeId)type, asArtifactB);
    }

    public void unrelateFromAll(TxData txData, ArtifactId artA) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        this.relationManager.unrelateFromAll(txData.getSession(), asArtifactA);
    }

    public void unrelateFromAll(TxData txData, IRelationType type, ArtifactId artA, RelationSide side) throws OseeCoreException {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        this.relationManager.unrelateFromAll(txData.getSession(), (RelationTypeId)type, asArtifactA, side);
    }

    public void setRelationApplicabilityId(TxData txData, ArtifactId artA, IRelationType type, ArtifactId artB, ApplicabilityId applicId) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.setApplicabilityId(txData.getSession(), asArtifactA, (RelationTypeId)type, asArtifactB, applicId);
    }

    public TransactionData createChangeData(TxData txData) throws OseeCoreException {
        OrcsSession session = txData.getSession();
        GraphData graph = txData.getGraph();
        ChangeSetBuilder builder = new ChangeSetBuilder();
        for (Artifact artifact : txData.getAllWriteables()) {
            artifact.accept(builder);
            this.relationManager.accept(session, graph, artifact, builder);
        }
        for (TupleData tuple : txData.getAllTuples()) {
            tuple.accept(builder);
        }
        OrcsChangeSet changeSet = builder.getChangeSet();
        return new TransactionDataImpl(txData.getBranch(), txData.getAuthor(), txData.getComment(), changeSet);
    }

    public void setApplicabilityId(TxData txData, ArtifactId artId, ApplicabilityId applicId) {
        Artifact asArtifactA = this.getForWrite(txData, artId);
        ((ArtifactData)asArtifactA.getOrcsData()).setApplicabilityId(applicId);
    }

    private static final class TransactionDataImpl
    implements TransactionData {
        private final BranchId branch;
        private final ArtifactId author;
        private final String comment;
        private final OrcsChangeSet changeSet;

        public TransactionDataImpl(BranchId branch, ArtifactId author, String comment, OrcsChangeSet changeSet) {
            this.branch = branch;
            this.author = author;
            this.comment = comment;
            this.changeSet = changeSet;
        }

        @Override
        public BranchId getBranch() {
            return this.branch;
        }

        @Override
        public ArtifactId getAuthor() {
            return this.author;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public OrcsChangeSet getChangeSet() {
            return this.changeSet;
        }

        public String toString() {
            return "TransactionDataImpl [branch=" + this.branch + ", author=" + this.author + ", comment=" + this.comment + ", changeSet=" + this.changeSet + "]";
        }
    }

    public static interface TxDataLoader {
        public GraphData createGraph(OrcsSession var1, BranchId var2) throws OseeCoreException;

        public ResultSet<Artifact> loadArtifacts(OrcsSession var1, BranchId var2, Collection<ArtifactId> var3) throws OseeCoreException;

        public ResultSet<Artifact> loadArtifacts(OrcsSession var1, GraphData var2, Collection<ArtifactId> var3) throws OseeCoreException;
    }
}

