/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.HasSession;

public class TxData
implements HasSession,
HasBranch {
    private final OrcsSession session;
    private final GraphData graph;
    private final Set<TupleData> tuples = new HashSet<TupleData>();
    private final Map<String, Artifact> writeables = new HashMap<String, Artifact>();
    private final Map<String, ArtifactReadable> readables = new HashMap<String, ArtifactReadable>();
    private ArtifactId author;
    private String comment;
    private volatile boolean isCommitInProgress;
    private volatile TxState txState;

    public TxData(OrcsSession session, GraphData graph) {
        this.session = session;
        this.graph = graph;
        this.txState = TxState.NEW_TX;
    }

    public void clear() {
        this.isCommitInProgress = false;
        this.writeables.clear();
        this.readables.clear();
    }

    public OrcsSession getSession() {
        return this.session;
    }

    public BranchId getBranch() {
        return this.graph.getBranch();
    }

    public GraphData getGraph() {
        return this.graph;
    }

    public ArtifactId getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public TxState getTxState() {
        return this.txState;
    }

    public boolean isCommitInProgress() {
        return this.isCommitInProgress;
    }

    public void setAuthor(ArtifactId author) {
        this.author = author;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTxState(TxState txState) {
        this.txState = txState;
    }

    public void setCommitInProgress(boolean isCommitInProgress) {
        this.isCommitInProgress = isCommitInProgress;
    }

    public Artifact add(Artifact artifact) {
        return this.writeables.put((String)artifact.getGuid(), artifact);
    }

    public void add(ArtifactReadable artifact) {
        this.readables.put((String)artifact.getGuid(), artifact);
    }

    public void add(TupleData tupleData) {
        this.tuples.add(tupleData);
    }

    public Iterable<TupleData> getAllTuples() {
        return this.tuples;
    }

    public Iterable<Artifact> getAllWriteables() {
        return this.writeables.values();
    }

    public Artifact getWriteable(ArtifactId artifactId) {
        return this.writeables.get(artifactId.getGuid());
    }

    public ArtifactReadable getReadable(ArtifactId artifactId) {
        return this.readables.get(artifactId.getGuid());
    }

    public String toString() {
        return "TxData [session=" + this.session + ", graph=" + this.graph + ", author=" + this.author + ", comment=" + this.comment + ", isCommitInProgress=" + this.isCommitInProgress + ", txState=" + (Object)((Object)this.txState) + "]";
    }

    public static enum TxState {
        NEW_TX,
        COMMIT_STARTED,
        COMMITTED,
        COMMIT_FAILED;

    }
}

