/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.model.change.CompareResults;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionBuilderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class TransactionFactoryImpl
implements TransactionFactory {
    private final OrcsSession session;
    private final TxDataManager txDataManager;
    private final TxCallableFactory txCallableFactory;
    private final QueryModule query;
    private final QueryFactory queryFactory;
    private final OrcsBranch orcsBranch;
    private final KeyValueOps keyValueOps;
    private final TxDataStore txDataStore;

    public TransactionFactoryImpl(OrcsSession session, TxDataManager txDataManager, TxCallableFactory txCallableFactory, QueryModule query, QueryFactory queryFactory, OrcsBranch orcsBranch, KeyValueOps keyValueOps, TxDataStore txDataStore) {
        this.session = session;
        this.txDataManager = txDataManager;
        this.txCallableFactory = txCallableFactory;
        this.query = query;
        this.queryFactory = queryFactory;
        this.orcsBranch = orcsBranch;
        this.keyValueOps = keyValueOps;
        this.txDataStore = txDataStore;
    }

    public CancellableCallable<Integer> purgeTransaction(Collection<? extends TransactionId> transactions) {
        return this.txCallableFactory.purgeTransactions(this.session, transactions);
    }

    public TransactionBuilder createTransaction(BranchId branch, ArtifactId author, String comment) throws OseeCoreException {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)author, (String)"author");
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.query, this.keyValueOps);
        orcsTxn.setComment(comment);
        orcsTxn.setAuthor(author);
        return orcsTxn;
    }

    public Callable<Void> setTransactionComment(TransactionId transaction, String comment) {
        return this.txCallableFactory.setTransactionComment(this.session, transaction, comment);
    }

    public CompareResults compareTxs(TransactionId txId1, TransactionId txId2) {
        TransactionReadable sourceTx = this.getTx(txId1);
        TransactionReadable destinationTx = this.getTx(txId2);
        try {
            List changes = (List)this.orcsBranch.compareBranch((TransactionToken)sourceTx, (TransactionToken)destinationTx).call();
            CompareResults data = new CompareResults();
            data.setChanges(changes);
            return data;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public boolean replaceWithBaselineTxVersion(String userId, BranchId branchId, TransactionId txId, int artId, String comment) {
        boolean introduced = false;
        ArtifactReadable userReadable = (ArtifactReadable)((QueryBuilder)this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andGuid(userId)).getResults().getOneOrNull();
        ArtifactReadable baselineArtifact = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.queryFactory.fromBranch(branchId).fromTransaction(txId)).andUuid((long)artId)).getResults().getOneOrNull();
        if (userReadable == null || baselineArtifact == null) {
            throw new OseeCoreException("%s Error - The user and baseline artifact were not found.", new Object[]{comment});
        }
        TransactionBuilder tx = this.createTransaction(branchId, (ArtifactId)userReadable, comment);
        ArtifactReadable destination = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.queryFactory.fromBranch(branchId).includeDeletedArtifacts()).andUuid((long)artId)).getResults().getOneOrNull();
        tx.replaceWithVersion(baselineArtifact, destination);
        tx.commit();
        introduced = true;
        return introduced;
    }

    public boolean purgeTxs(String txIds) {
        ResultSet results;
        boolean modified = false;
        List txsToDelete = Collections.fromString((String)txIds, TransactionId::valueOf);
        if (!txsToDelete.isEmpty() && !(results = ((TransactionQuery)this.queryFactory.transactionQuery().andTxIds((Collection)txsToDelete)).getResults()).isEmpty()) {
            this.checkAllTxsFound("Purge Transaction", txsToDelete, (ResultSet<? extends TransactionId>)results);
            ArrayList list = Lists.newArrayList((Iterable)results);
            try {
                this.purgeTransaction((Collection<? extends TransactionId>)list).call();
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
            modified = true;
        }
        return modified;
    }

    public boolean setTxComment(TransactionId txId, String comment) {
        TransactionReadable tx = this.getTx(txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            this.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return modified;
    }

    public ResultSet<TransactionReadable> getAllTxs() {
        return this.queryFactory.transactionQuery().getResults();
    }

    public TransactionReadable getTx(TransactionId tx) {
        if (tx instanceof TransactionReadable) {
            return (TransactionReadable)tx;
        }
        return (TransactionReadable)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(tx)).getResults().getExactlyOne();
    }

    private void checkAllTxsFound(String opName, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeNotFoundException("%s Error - The following transactions from %s were not found - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, difference});
        }
    }

    public int[] purgeUnusedBackingDataAndTransactions() {
        return this.txDataStore.purgeUnusedBackingDataAndTransactions();
    }
}

