/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private final TxCallableFactory txFactory;
    private final TxDataManager txManager;
    private final TxData txData;
    private final QueryModule query;
    private final KeyValueOps keyValueOps;

    public TransactionBuilderImpl(TxCallableFactory txFactory, TxDataManager dataManager, TxData txData, QueryModule query, KeyValueOps keyValueOps) {
        this.txFactory = txFactory;
        this.txManager = dataManager;
        this.txData = txData;
        this.query = query;
        this.keyValueOps = keyValueOps;
    }

    private Artifact getForWrite(ArtifactId artifactId) throws OseeCoreException {
        return this.txManager.getForWrite(this.txData, artifactId);
    }

    public BranchId getBranch() {
        return this.txData.getBranch();
    }

    public String getComment() {
        return this.txData.getComment();
    }

    public void setComment(String comment) throws OseeCoreException {
        this.txManager.setComment(this.txData, comment);
    }

    public void setAuthor(ArtifactId author) throws OseeCoreException {
        this.txManager.setAuthor(this.txData, author);
    }

    public ArtifactToken createArtifact(IArtifactType artifactType, String name) throws OseeCoreException {
        return this.createArtifact(artifactType, name, null);
    }

    public ArtifactToken createArtifact(IArtifactType artifactType, String name, String guid) throws OseeCoreException {
        return this.txManager.createArtifact(this.txData, artifactType, name, guid);
    }

    public ArtifactToken createArtifact(IArtifactType artifactType, String name, String guid, long uuid) throws OseeCoreException {
        Conditions.checkExpressionFailOnTrue((uuid <= 0L ? 1 : 0) != 0, (String)"Invalid Uuid %d. Must be > 0", (Object[])new Object[]{uuid});
        return this.txManager.createArtifact(this.txData, artifactType, name, guid, uuid);
    }

    public ArtifactToken createArtifact(ArtifactToken token) throws OseeCoreException {
        Conditions.checkExpressionFailOnTrue((boolean)token.isInvalid(), (String)"Invalid Id %d. Must be > 0", (Object[])new Object[]{token.getId()});
        return this.txManager.createArtifact(this.txData, token.getArtifactType(), token.getName(), (String)token.getGuid(), token.getId());
    }

    public ArtifactToken copyArtifact(ArtifactReadable sourceArtifact) throws OseeCoreException {
        return this.copyArtifact(sourceArtifact.getBranch(), (ArtifactId)sourceArtifact);
    }

    public ArtifactToken copyArtifact(BranchId fromBranch, ArtifactId artifactId) throws OseeCoreException {
        return this.txManager.copyArtifact(this.txData, fromBranch, artifactId);
    }

    public ArtifactToken copyArtifact(ArtifactReadable sourceArtifact, Collection<AttributeTypeId> attributesToDuplicate) throws OseeCoreException {
        return this.copyArtifact(sourceArtifact.getBranch(), (ArtifactId)sourceArtifact, attributesToDuplicate);
    }

    public ArtifactToken copyArtifact(BranchId fromBranch, ArtifactId artifactId, Collection<AttributeTypeId> attributesToDuplicate) throws OseeCoreException {
        return this.txManager.copyArtifact(this.txData, fromBranch, artifactId, attributesToDuplicate);
    }

    public ArtifactToken introduceArtifact(BranchId fromBranch, ArtifactId sourceArtifact) throws OseeCoreException {
        this.checkAreOnDifferentBranches(this.txData, fromBranch);
        ArtifactReadable source = this.getArtifactReadable(this.txData.getSession(), this.query, fromBranch, sourceArtifact);
        Conditions.checkNotNull((Object)source, (String)"Source Artifact");
        ArtifactReadable destination = this.getArtifactReadable(this.txData.getSession(), this.query, this.txData.getBranch(), sourceArtifact);
        return this.txManager.introduceArtifact(this.txData, fromBranch, source, destination);
    }

    public ArtifactToken replaceWithVersion(ArtifactReadable sourceArtifact, ArtifactReadable destination) throws OseeCoreException {
        return this.txManager.replaceWithVersion(this.txData, sourceArtifact.getBranch(), sourceArtifact, destination);
    }

    public AttributeId createAttribute(ArtifactId sourceArtifact, AttributeTypeId attributeType) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType);
    }

    public <T> AttributeId createAttribute(ArtifactId sourceArtifact, AttributeTypeId attributeType, T value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType, value);
    }

    public AttributeId createAttributeFromString(ArtifactId sourceArtifact, AttributeTypeId attributeType, String value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttributeFromString(attributeType, value);
    }

    public <T> void setSoleAttributeValue(ArtifactId sourceArtifact, AttributeTypeId attributeType, T value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeValue(attributeType, value);
    }

    public void setSoleAttributeFromStream(ArtifactId sourceArtifact, AttributeTypeId attributeType, InputStream stream) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeFromStream(attributeType, stream);
    }

    public void setSoleAttributeFromString(ArtifactId sourceArtifact, AttributeTypeId attributeType, String value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeFromString(attributeType, value);
    }

    public void setName(ArtifactId sourceArtifact, String value) throws OseeCoreException {
        this.setSoleAttributeFromString(sourceArtifact, (AttributeTypeId)CoreAttributeTypes.Name, value);
    }

    public <T> void setAttributesFromValues(ArtifactId sourceArtifact, AttributeTypeId attributeType, T ... values) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromValues(attributeType, values);
    }

    public <T> void setAttributesFromValues(ArtifactId sourceArtifact, AttributeTypeId attributeType, Collection<T> values) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromValues(attributeType, values);
    }

    public void setAttributesFromStrings(ArtifactId sourceArtifact, AttributeTypeId attributeType, String ... values) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromStrings(attributeType, values);
    }

    public void setAttributesFromStrings(ArtifactId sourceArtifact, AttributeTypeId attributeType, Collection<String> values) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromStrings(attributeType, values);
    }

    public <T> void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, T value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId.getLocalId()).setValue(value);
    }

    public void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, String value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId.getLocalId()).setFromString(value);
    }

    public void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, InputStream stream) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId.getLocalId()).setValueFromInputStream(stream);
    }

    public void setAttributeApplicability(ArtifactId art, AttributeId attrId, ApplicabilityId applicId) {
        Artifact asArtifact = this.getForWrite(art);
        Attribute attribute = asArtifact.getAttributeById(attrId.getLocalId());
        ((AttributeData)attribute.getOrcsData()).setApplicabilityId(applicId);
    }

    public void deleteByAttributeId(ArtifactId sourceArtifact, AttributeId attrId) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId.getLocalId()).delete();
    }

    public void deleteSoleAttribute(ArtifactId sourceArtifact, AttributeTypeId attributeType) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteSoleAttribute(attributeType);
    }

    public void deleteAttributes(ArtifactId sourceArtifact, AttributeTypeId attributeType) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteAttributes(attributeType);
    }

    public void deleteAttributesWithValue(ArtifactId sourceArtifact, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteAttributesWithValue(attributeType, value);
    }

    public void addChildren(ArtifactId artA, ArtifactId ... children) throws OseeCoreException {
        this.addChildren(artA, Arrays.asList(children));
    }

    public void addChildren(ArtifactId artA, Iterable<? extends ArtifactId> children) throws OseeCoreException {
        this.txManager.addChildren(this.txData, artA, children);
    }

    public void relate(ArtifactId artA, IRelationType relType, ArtifactId artB) throws OseeCoreException {
        this.txManager.relate(this.txData, artA, relType, artB);
    }

    public void relate(ArtifactId artA, IRelationType relType, ArtifactId artB, String rationale) throws OseeCoreException {
        this.txManager.relate(this.txData, artA, relType, artB, rationale);
    }

    public void relate(ArtifactId artA, IRelationType relType, ArtifactId artB, RelationSorter sortType) throws OseeCoreException {
        this.txManager.relate(this.txData, artA, relType, artB, sortType);
    }

    public void relate(ArtifactId artA, IRelationType relType, ArtifactId artB, String rationale, RelationSorter sortType) throws OseeCoreException {
        this.txManager.relate(this.txData, artA, relType, artB, rationale, sortType);
    }

    public void setRelations(ArtifactId artA, IRelationType relType, Iterable<? extends ArtifactId> artBs) throws OseeCoreException {
        this.txManager.setRelations(this.txData, artA, relType, artBs);
    }

    public void setRationale(ArtifactId artA, IRelationType relType, ArtifactId artB, String rationale) throws OseeCoreException {
        this.txManager.setRationale(this.txData, artA, relType, artB, rationale);
    }

    public void unrelate(ArtifactId artA, IRelationType relType, ArtifactId artB) throws OseeCoreException {
        this.txManager.unrelate(this.txData, artA, relType, artB);
    }

    public void unrelateFromAll(RelationTypeSide typeAndSide, ArtifactId art) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        this.txManager.unrelateFromAll(this.txData, (IRelationType)type, art, typeAndSide.getSide());
    }

    public void unrelateFromAll(ArtifactId artA) throws OseeCoreException {
        this.txManager.unrelateFromAll(this.txData, artA);
    }

    public void setRelationApplicability(ArtifactId artA, IRelationType relType, ArtifactId artB, ApplicabilityId applicId) {
        this.txManager.setRelationApplicabilityId(this.txData, artA, relType, artB, applicId);
    }

    public void deleteArtifact(ArtifactId sourceArtifact) throws OseeCoreException {
        this.txManager.deleteArtifact(this.txData, sourceArtifact);
    }

    public boolean isCommitInProgress() {
        return this.txData.isCommitInProgress();
    }

    public TransactionReadable commit() throws OseeCoreException {
        try {
            CancellableCallable<TransactionReadable> callable = this.txFactory.createTx(this.txData);
            return (TransactionReadable)callable.call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void checkAreOnDifferentBranches(TxData txData, BranchId sourceBranch) throws OseeCoreException {
        boolean isOnSameBranch = txData.isOnBranch(sourceBranch);
        Conditions.checkExpressionFailOnTrue((boolean)isOnSameBranch, (String)"Source branch is same branch as transaction branch[%s]", (Object[])new Object[]{txData.getBranch()});
    }

    protected ArtifactReadable getArtifactReadable(OrcsSession session, QueryModule query, BranchId branch, ArtifactId id) {
        return (ArtifactReadable)((QueryBuilder)((QueryBuilder)query.createQueryFactory(session).fromBranch(branch).includeDeletedArtifacts()).andId(id)).getResults().getOneOrNull();
    }

    public void setApplicability(ArtifactId artId, ApplicabilityId applicId) {
        this.txManager.setApplicabilityId(this.txData, artId, applicId);
    }

    private Long insertValue(String value) {
        return this.keyValueOps.putIfAbsent(value);
    }

    public <E1, E2> Long addTuple2(Tuple2Type<E1, E2> tupleType, E1 element1, E2 element2) {
        return this.addTuple((TupleTypeId)tupleType, element1, element2);
    }

    public <E1, E2, E3> Long addTuple3(Tuple3Type<E1, E2, E3> tupleType, E1 element1, E2 element2, E3 element3) {
        return this.addTuple((TupleTypeId)tupleType, element1, element2, element3);
    }

    public <E1, E2, E3, E4> Long addTuple4(Tuple4Type<E1, E2, E3, E4> tupleType, E1 element1, E2 element2, E3 element3, E4 element4) {
        return this.addTuple((TupleTypeId)tupleType, element1, element2, element3, element4);
    }

    public Long addTuple(TupleTypeId tupleType, Object ... elements) {
        int length = elements.length;
        if (length == 2) {
            return this.addTuple2(tupleType, this.txData.getBranch(), elements[0], elements[1]);
        }
        if (length == 3) {
            return this.addTuple3(tupleType, this.txData.getBranch(), elements[0], elements[1], elements[2]);
        }
        return this.addTuple4(tupleType, this.txData.getBranch(), elements[0], elements[1], elements[2], elements[3]);
    }

    private Long addTuple2(TupleTypeId tupleTypeId, BranchId branch, Object element1, Object element2) {
        Long e1 = element1 instanceof String ? this.insertValue((String)element1) : (element1 instanceof Id ? ((Id)element1).getId() : (element1 instanceof AttributeId ? Long.valueOf(((AttributeId)element1).getLocalId().intValue()) : (Long)element1));
        Long e2 = element2 instanceof String ? this.insertValue((String)element2) : (element1 instanceof ArtifactId ? ((Id)element2).getId() : (element2 instanceof AttributeId ? Long.valueOf(((AttributeId)element2).getLocalId().intValue()) : (Long)element2));
        return this.txManager.createTuple2(this.txData, branch, tupleTypeId.getId(), e1, e2);
    }

    private Long addTuple3(TupleTypeId tupleTypeId, BranchId branch, Object element1, Object element2, Object element3) {
        Long e1 = element1 instanceof String ? this.insertValue((String)element1) : (Long)element1;
        Long e2 = element2 instanceof String ? this.insertValue((String)element2) : (Long)element2;
        Long e3 = element3 instanceof String ? this.insertValue((String)element3) : (Long)element3;
        return this.txManager.createTuple3(this.txData, branch, tupleTypeId.getId(), e1, e2, e3);
    }

    private Long addTuple4(TupleTypeId tupleTypeId, BranchId branch, Object element1, Object element2, Object element3, Object element4) {
        Long e1 = element1 instanceof String ? this.insertValue((String)element1) : (Long)element1;
        Long e2 = element2 instanceof String ? this.insertValue((String)element2) : (Long)element2;
        Long e3 = element3 instanceof String ? this.insertValue((String)element3) : (Long)element3;
        Long e4 = element4 instanceof String ? this.insertValue((String)element4) : (Long)element4;
        return this.txManager.createTuple4(this.txData, branch, tupleTypeId.getId(), e1, e2, e3, e4);
    }

    public boolean deleteTuple(Long gammaId) {
        return false;
    }

    public <E1, E2> boolean deleteTuple2(Tuple2Type<E1, E2> tupleType, E1 element1, E2 element2) {
        return false;
    }

    public <E1, E2, E3> boolean deleteTupple3(Tuple3Type<E1, E2, E3> tupleType, E1 element1, E2 element2, E3 element3) {
        return false;
    }

    public <E1, E2, E3, E4> boolean deleteTupple4(Tuple4Type<E1, E2, E3, E4> tupleType, E1 element1, E2 element2, E3 element3, E4 element4) {
        return false;
    }
}

