/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.HasOrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactVisitor;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.tuple.TupleVisitor;

public class ChangeSetBuilder
implements ArtifactVisitor,
RelationVisitor,
TupleVisitor,
HasOrcsChangeSet {
    private final OrcsChangeSetImpl changeSet = new OrcsChangeSetImpl();

    @Override
    public void visit(Artifact artifact) {
        if (artifact.isDirty()) {
            this.changeSet.arts.add((ArtifactData)artifact.getOrcsData());
        }
    }

    @Override
    public void visit(Attribute<?> attribute) {
        if (attribute.isDirty()) {
            this.changeSet.attrs.add((AttributeData)attribute.getOrcsData());
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isDirty()) {
            this.changeSet.rels.add(relation.getOrcsData());
        }
    }

    @Override
    public void visit(TupleData tuple) throws OseeCoreException {
        this.changeSet.tuples.add(tuple);
    }

    @Override
    public OrcsChangeSet getChangeSet() {
        return this.changeSet;
    }

    private static final class OrcsChangeSetImpl
    implements OrcsChangeSet {
        private final Set<ArtifactData> arts = Sets.newLinkedHashSet();
        private final Set<AttributeData> attrs = Sets.newLinkedHashSet();
        private final Set<RelationData> rels = Sets.newLinkedHashSet();
        private final Set<TupleData> tuples = Sets.newLinkedHashSet();

        private OrcsChangeSetImpl() {
        }

        @Override
        public void accept(OrcsVisitor visitor) throws OseeCoreException {
            for (ArtifactData artifactData : this.getArtifactData()) {
                visitor.visit(artifactData);
            }
            for (AttributeData attributeData : this.getAttributeData()) {
                visitor.visit(attributeData);
            }
            for (RelationData relationData : this.getRelationData()) {
                visitor.visit(relationData);
            }
            for (TupleData tupleData : this.getTupleData()) {
                visitor.visit(tupleData);
            }
        }

        @Override
        public Iterable<ArtifactData> getArtifactData() {
            return this.arts;
        }

        @Override
        public Iterable<AttributeData> getAttributeData() {
            return this.attrs;
        }

        @Override
        public Iterable<RelationData> getRelationData() {
            return this.rels;
        }

        @Override
        public Iterable<TupleData> getTupleData() {
            return this.tuples;
        }

        @Override
        public boolean isEmpty() {
            return this.arts.isEmpty() && this.attrs.isEmpty() && this.rels.isEmpty() && this.tuples.isEmpty();
        }

        @Override
        public int size() {
            return this.arts.size() + this.attrs.size() + this.rels.size();
        }

        public String toString() {
            return "OrcsChangeSetImpl [arts=" + this.arts + ", attrs=" + this.attrs + ", rels=" + this.rels + "]";
        }
    }
}

