/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxArtifactIds;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxIds;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.search.Operator;
import org.eclipse.osee.orcs.search.TxQueryBuilder;

public class TxQueryBuilderImpl<T>
implements TxQueryBuilder<T> {
    private final TransactionCriteriaFactory criteriaFactory;
    private final QueryData queryData;

    public TxQueryBuilderImpl(TransactionCriteriaFactory criteriaFactory, QueryData queryData) {
        this.criteriaFactory = criteriaFactory;
        this.queryData = queryData;
    }

    private QueryData getQueryData() {
        return this.queryData;
    }

    private Options getOptions() {
        return this.queryData.getOptions();
    }

    public T andTxIds(Collection<TransactionId> ids) throws OseeCoreException {
        return this.addAndCheck(this.queryData, new CriteriaTxIds(ids));
    }

    public T andTxId(Operator op, int id) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByIdWithOperator(op, id);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andTxId(Operator op1, int id1, Operator op2, int id2) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByIdWithTwoOperators(op1, id1, op2, id2);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andCommentEquals(String value) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newCommentCriteria(value, false);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andCommentPattern(String pattern) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newCommentCriteria(pattern, true);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andIs(TransactionDetailsType ... types) throws OseeCoreException {
        return this.andIs(Arrays.asList(types));
    }

    public T andIs(Collection<TransactionDetailsType> types) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newTxTypeCriteria(types);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andBranch(BranchId ... ids) throws OseeCoreException {
        return this.andBranch(Arrays.asList(ids));
    }

    public T andBranch(Collection<? extends BranchId> ids) throws OseeCoreException {
        LinkedHashSet<Long> values = new LinkedHashSet<Long>();
        for (BranchId branchId : ids) {
            values.add(branchId.getUuid());
        }
        Criteria criteria = this.criteriaFactory.newTxBranchIdCriteria(values);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andBranchIds(long ... ids) throws OseeCoreException {
        LinkedHashSet<Long> values = new LinkedHashSet<Long>();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            values.add(value);
            ++n2;
        }
        return this.andBranchIds(values);
    }

    public T andBranchIds(Collection<Long> ids) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newTxBranchIdCriteria(ids);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andDate(Operator op, Timestamp date) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByDateWithOperator(op, date);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andDate(Timestamp from, Timestamp to) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByDateRange(from, to);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andAuthorLocalIds(ArtifactId ... id) throws OseeCoreException {
        return this.andAuthorLocalIds(Arrays.asList(id));
    }

    public T andAuthorLocalIds(Collection<ArtifactId> ids) throws OseeCoreException {
        return this.addAndCheck(this.queryData, new CriteriaTxArtifactIds(ids));
    }

    public T andAuthorIds(int ... id) throws OseeCoreException {
        ArrayList<Integer> theList = new ArrayList<Integer>();
        int i = 0;
        while (i < id.length) {
            theList.add(new Integer(id[i]));
            ++i;
        }
        return this.andAuthorIds(theList);
    }

    public T andAuthorIds(Collection<Integer> ids) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByAuthorId(ids);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andCommitIds(Integer ... id) throws OseeCoreException {
        return this.andCommitIds(Arrays.asList(id));
    }

    public T andNullCommitId() throws OseeCoreException {
        ArrayList<Integer> aNull = new ArrayList<Integer>();
        aNull.add(null);
        return this.andCommitIds(aNull);
    }

    public T andCommitIds(Collection<Integer> ids) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newByCommitId(ids);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andIsHead(BranchId branch) {
        Criteria criteria = this.criteriaFactory.newGetHead(branch);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andIsPriorTx(TransactionId txId) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.newGetPriorTx(txId);
        return this.addAndCheck(this.queryData, criteria);
    }

    private T addAndCheck(QueryData queryData, Criteria criteria) throws OseeCoreException {
        criteria.checkValid(this.getOptions());
        queryData.addCriteria(criteria);
        return (T)this;
    }

    public QueryData buildAndCopy() {
        return this.build(true);
    }

    public QueryData build() {
        return this.build(false);
    }

    private QueryData build(boolean clone) {
        QueryData queryData;
        QueryData queryData2 = queryData = clone ? this.getQueryData().clone() : this.getQueryData();
        if (queryData.getAllCriteria().isEmpty()) {
            this.addAndCheck(queryData, this.criteriaFactory.createAllTransactionsCriteria());
        }
        return queryData;
    }

    public T andTxId(TransactionId id) {
        return this.addAndCheck(this.queryData, new CriteriaTxIds(id));
    }
}

